package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.service.IBusinessInfoService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.wisenergy.chnmuseum.party.mapper.BusinessInfoMapper;
import cn.wisenergy.chnmuseum.party.model.BusinessInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 * 业务信息表 服务实现类
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@Service
public class BusinessInfoServiceImpl extends ServiceImpl<BusinessInfoMapper, BusinessInfo> implements IBusinessInfoService {

    @Resource
    private BusinessInfoMapper businessInfoMapper;

    public BusinessInfo selectOneById(String id) {
        return this.businessInfoMapper.selectOneById(id);
    }

    public Page<BusinessInfo> selectListByName(Page<BusinessInfo> page, String name, String bankId,
                                               String roleId,String currentBankId,String userId) {
        page.setRecords(businessInfoMapper.selectListByName(page, name, bankId, roleId, currentBankId, userId));
        return page;
    }

}
