package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.service.IDemandInfoService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.wisenergy.chnmuseum.party.mapper.DemandInfoMapper;
import cn.wisenergy.chnmuseum.party.model.DemandInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 需求建议信息 服务实现类
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@Service
public class DemandInfoServiceImpl extends ServiceImpl<DemandInfoMapper, DemandInfo> implements IDemandInfoService {

    @Resource
    private DemandInfoMapper demandInfoMapper;

    public DemandInfo selectOneById(String id) {
        return this.demandInfoMapper.selectOneById(id);
    }

    public Page<DemandInfo> selectDemandInfoList(Page<DemandInfo> page,
                                                 String lineNumber,
                                                 String content,
                                                 String phoneNumber,
                                                 String startDate,
                                                 String endDate,
                                                 Integer type,
                                                 String bankBranchId,
                                                 String callStartDate,
                                                 String callEndDate,
                                                 String roleId,
                                                 String currentBankId) {
        page.setRecords(demandInfoMapper.selectDemandInfoList(page, lineNumber, content, phoneNumber,
                startDate, endDate, type, bankBranchId,callStartDate,callEndDate,roleId,currentBankId));
        return page;
    }

    public List<DemandInfo> selectDemandInfoList(
                                                 String lineNumber,
                                                 String content,
                                                 String phoneNumber,
                                                 String startDate,
                                                 String endDate,
                                                 Integer type,
                                                 String bankBranchId,
                                                 String callStartDate,
                                                 String callEndDate,
                                                 String roleId,
                                                 String currentBankId) {
        return demandInfoMapper.selectDemandInfoList(lineNumber, content, phoneNumber,
                startDate, endDate, type, bankBranchId,callStartDate,callEndDate,roleId,currentBankId);
    }

}
