package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.service.IEmployeeService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.wisenergy.chnmuseum.party.mapper.EmployeeMapper;
import cn.wisenergy.chnmuseum.party.model.Employee;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 组织成员 服务实现类
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-02
 */
@Service
public class EmployeeServiceImpl extends ServiceImpl<EmployeeMapper, Employee> implements IEmployeeService {

    @Resource
    private EmployeeMapper employeeMapper;

    public Page<Employee> selectRolenameList(Page<Employee> page, String name) {
        page.setRecords(employeeMapper.selectRolenameList(page, name));
        return page;
    }

    public Page<Employee> selectOwnEmpList(Page<Employee> page, String name, String currBankID) {
        page.setRecords(employeeMapper.selectOwnEmpList(page, name, currBankID));
        return page;
    }

    public Employee selectByEmpId(String empId) {
        return this.employeeMapper.selectByEmpId(empId);
    }

    public Employee selectByUsername(String username) {
        return this.employeeMapper.selectByUsername(username);
    }

    /**
     * 获取当前网点的大堂主管员工号，多人使用|分割，如"01014760|01158451"
     */
    public Employee getEmpCodeBybankId(String bankId) {
        /*String recUsrNbr = "";
        List<Employee> empCodeList = this.employeeMapper.getEmpCodeBybankId(bankId);
        if(empCodeList.size() > 0){
            for (Employee employee : empCodeList){
                if("".equals(recUsrNbr)){
                    recUsrNbr = employee.getCode();
                }else {
                    recUsrNbr += "|" + employee.getCode();
                }
            }
        }

        return recUsrNbr;*/

        Employee emp = this.employeeMapper.getEmpCodeBybankId(bankId);
        return emp;
    }

    //判断该网点下是否有启用的大堂主管
    public Boolean isHasEnHallDirector(String employeeId, String currBankId) {
        boolean flag = false;
        List<Employee> empList = this.employeeMapper.selectEmpListByBankId(employeeId, currBankId);
        if (empList.size() > 0) {
            flag = true;
        }
        return flag;
    }

}
