package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.mapper.LearningContentBoardMapper;
import cn.wisenergy.chnmuseum.party.model.Asset;
import cn.wisenergy.chnmuseum.party.model.ExhibitionBoard;
import cn.wisenergy.chnmuseum.party.model.LearningContentBoard;
import cn.wisenergy.chnmuseum.party.service.LearningContentBoardService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 学习内容展板 服务实现类
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-16
 */
@Service
public class LearningContentBoardServiceImpl extends ServiceImpl<LearningContentBoardMapper, LearningContentBoard> implements LearningContentBoardService {

    @Resource
    private LearningContentBoardMapper learningContentBoardMapper;

    @Override
    public List<LearningContentBoard> getBoardListByLearningContentId(String learningContentId) {
        return learningContentBoardMapper.selectBoardListByLearningContentId(learningContentId);
    }

    @Override
    public IPage<ExhibitionBoard> getBoardPageByLearningContentId(Page<ExhibitionBoard> page, String learningContentId, String nameOrCode) {
        return learningContentBoardMapper.selectBoardPageByLearningContentId(page, learningContentId, nameOrCode);
    }

    @Override
    public IPage<Asset> getAssetPageByOrganCode(Page<Asset> page, String organCode) {
        return learningContentBoardMapper.selectAssetPageByOrganCode(page, organCode);
    }

}
