package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.service.IProductAppointmentRecordService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.wisenergy.chnmuseum.party.mapper.ProductAppointmentRecordMapper;
import cn.wisenergy.chnmuseum.party.model.ProductAppointmentRecord;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 产品活动预约记录表 服务实现类
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@Service
public class ProductAppointmentRecordServiceImpl extends ServiceImpl<ProductAppointmentRecordMapper, ProductAppointmentRecord> implements IProductAppointmentRecordService {

    @Resource
    private ProductAppointmentRecordMapper productAppointmentRecordMapper;

    public Page<ProductAppointmentRecord> getPARList(Page<ProductAppointmentRecord> page, Map<String, Object> map) {
        page.setRecords(productAppointmentRecordMapper.getPARList(page, map));
        return page;
    }

    public List<ProductAppointmentRecord> downLoadPAR(Map<String, Object> map) {
        return productAppointmentRecordMapper.downLoadPAR(map);
    }

    public List<ProductAppointmentRecord> getPARListOnApp(Map<String, Object> map) {
        return productAppointmentRecordMapper.getPARListOnApp(map);
    }

}
