package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.model.TBoxOperation;
import cn.wisenergy.chnmuseum.party.mapper.TBoxOperationMapper;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.service.TBoxOperationService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * <pre>
 * 机顶盒运维信息 服务实现类
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-25
 */
@Slf4j
@Service
public class TBoxOperationServiceImpl extends ServiceImpl<TBoxOperationMapper, TBoxOperation> implements TBoxOperationService {

    @Autowired
    private TBoxOperationMapper tBoxOperationMapper;

    @Override
    public List<TBoxOperation> getList(String status, String areaId) {
        return tBoxOperationMapper.getList(status, areaId);
    }

    @Override
    public Page<TBoxOperation> selectBoxPage(Page<TBoxOperation> page, TUser user) {
        return page.setRecords(tBoxOperationMapper.selectBoxPage(page, user));
    }

    @Override
    public Page<TBoxOperation> selectPage(Page<TBoxOperation> page, TBoxOperation tBoxOperation) {
        return page.setRecords(tBoxOperationMapper.selectPageList(page, tBoxOperation));
    }
}

