package cn.wisenergy.chnmuseum.party.service.impl;


import cn.wisenergy.chnmuseum.party.common.util.DateUtil80;
import cn.wisenergy.chnmuseum.party.mapper.TAreaMapper;
import cn.wisenergy.chnmuseum.party.model.TArea;
import cn.wisenergy.chnmuseum.party.model.TOrgan;
import cn.wisenergy.chnmuseum.party.mapper.TOrganMapper;
import cn.wisenergy.chnmuseum.party.service.TOrganService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <pre>
 * 用户 服务实现类
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-22
 */
@Slf4j
@Service
public class TOrganServiceImpl extends ServiceImpl<TOrganMapper, TOrgan> implements TOrganService {

    @Resource
    private TOrganMapper organMapper;

    @Resource
    private TAreaMapper areaMapper;

    @Override
    public List<TOrgan> getTree(String orgCode) {
        List<TOrgan> list = list(Wrappers.<TOrgan>lambdaQuery().eq(TOrgan::getIsDeleted, 0).likeRight(TOrgan::getCode,orgCode).orderByDesc(TOrgan::getLevel));
        HashMap<String, TOrgan> map = new HashMap<>();
        list.forEach(o-> map.put(o.getId(),o));
        for (TOrgan o : list) {
            TOrgan parentOrg= map.get(o.getParentId());
            if(parentOrg!=null){
                //说明有值
                if(parentOrg.getChildren()==null){
                    parentOrg.setChildren(new ArrayList<>());
                }
                parentOrg.getChildren().add(o);
            }
        }
        list = list.stream().filter(o -> o.getLevel() == 1).collect(Collectors.toList());
        return list;
    }

    @Override
    public boolean batchUpload(List excelList) {
        boolean flag =false;
        List<TOrgan> list1 = list();
        HashMap<String, TOrgan> map1 = new HashMap<>();
        list1.stream().forEach(o-> map1.put(o.getName(),o));

        HashMap<String, String> area = new HashMap<>();

        List<Map<String, Object>> mapList = organMapper.selectArea();
        mapList.stream().forEach(m->area.put(m.get("name").toString(),m.get("id").toString()));

        for (int i = 0; i < excelList.size(); i++) {
            Map<String, String> map = null;
            map = (Map<String, String>) excelList.get(i);
            TOrgan organ = new TOrgan();
            organ.setName(map.get("名称"));

            //机构名称不能重复
            QueryWrapper<TOrgan> ew = new QueryWrapper<>();
            if (StringUtils.isNoneBlank(organ.getName())) {
                organ.setName(organ.getName().trim());
                ew.eq("is_deleted", 0);
                ew.eq("name", organ.getName());
                List<TOrgan> list = list(ew);
                if (list != null&&list.size()>0&&list.get(0)!=null) {
                    return flag;
                }
            }



            String parent = map.get("上级机构");
            if (map1.get(parent)==null){
                organ.setParentId("0");
                organ.setLevel(1);
            }else {
                organ.setParentId(map1.get(parent).getId());
                organ.setLevel(map1.get(parent).getLevel()+1);
            }
            if (organ.getLevel()>3){
                return false;
            }
            String organCode = getOrganCode(organ.getParentId());
            organ.setCode(organCode);
            organ.setAreaId(area.get(map.get("区域")));
            organ.setRemarks(map.get("备注"));
            organ.setIsDeleted(false);
            organ.setCreateTime(DateUtil80.getDateTimeOfTimestamp(System.currentTimeMillis()));
            organ.setUpdateTime(LocalDateTime.now());
            flag = save(organ);
//            list.add(organ);
        }
//        flag = saveBatch(list);
        return flag;
    }

    @Override
    public TOrgan selectById(String id) {
        TOrgan organ = organMapper.getById(id);
        String s = areaMapper.selectParent(organ.getAreaId());
        List<TOrgan> list1 = list(new UpdateWrapper<TOrgan>().eq("parent_id", organ.getId()));
        organ.setAreas(Arrays.asList(s.split(",")));
        organ.setChildren(list1);
        return organ;
    }

    @Override
    public TOrgan selectCodeMax(String parentId) {
        return organMapper.selectCodeMax(parentId);
    }

    @Override
    public List<TOrgan> getAllList(TOrgan tOrgan) {
        return organMapper.getAllList(tOrgan);
    }


    private String getOrganCode(String parentId) {
        TOrgan max = selectCodeMax(parentId);
        if (max==null){
            max = getById(parentId);
            String s = max.getCode() + "001";
            return s;
        }
        String s = max.getCode().substring(max.getCode().length() - 3);
        String s1 = max.getCode().substring(0,max.getCode().length() - 3);
        Integer integer = Integer.valueOf(s)+1;
        if (integer<10){
            s1=s1+"00"+integer.toString();
        }else if (integer<100){
            s1=s1+"0"+integer.toString();
        }else {
            s1=s1+integer.toString();
        }
        return s1;
    }
}
