package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;
import cn.wisenergy.chnmuseum.party.model.LearningContentBoard;
import cn.wisenergy.chnmuseum.party.service.LearningContentBoardService;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 学习内容展板 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Slf4j
@RestController
@RequestMapping("/learningContentBoard")
@Api(tags = {"学习内容-展板列表操作接口"})
public class LearningContentBoardController extends BaseController {

    @Resource
    private LearningContentBoardService learningContentBoardService;

    @GetMapping("/getList")
    @RequiresAuthentication  //@RequiresPermissions("learning:content:board:list")
    @ApiOperation(value = "获取学习内容展板全部列表(无分页)", notes = "获取学习内容展板全部列表(无分页)")
    public Map<String, Object> getLearningContentBoardList(String learningContentId) {
        final List<LearningContentBoard> learningContentBoardList = learningContentBoardService.getBoardListByLearningContentId(learningContentId);
        return getResult(learningContentBoardList);
    }

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "nameOrCode", value = "名称或编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String")
    })
    @PostMapping("/getPageList")
    @RequiresAuthentication  //@RequiresPermissions("learning:content:board:page")
    @ApiOperation(value = "获取学习内容展板分页列表", notes = "获取学习内容展板分页列表")
    public Map<String, Object> getLearningContentBoardPageList(GenericPageParam genericPageParam) {
        LambdaQueryWrapper<LearningContentBoard> queryWrapper = new LambdaQueryWrapper<>();
        // 设置查询内容
        queryWrapper.select(
                LearningContentBoard::getId,
                LearningContentBoard::getLearningContentId,
                LearningContentBoard::getExhibitionBoardId);
        // 设置排序规则
        queryWrapper.orderByDesc(LearningContentBoard::getSortorder);
        Page<LearningContentBoard> page = this.learningContentBoardService.page(getPage(), queryWrapper);
        return getResult(page);
    }

    /**
     * 通用排序方法(拖拽排序/所有排序完成后点击保存)
     *
     * @param sourceId 源实体ID
     * @param targetId 目标实体ID
     * @return Void
     */
    @ApiOperation(value = "学习内容-展板排序")
    @PutMapping(value = "/sort")
    @RequiresAuthentication  //@RequiresPermissions("learning:content:board:sort")
    public Map<String, Object> sort(String sourceId, String targetId) {
        String moveType;
        LearningContentBoard theSource = this.learningContentBoardService.getById(sourceId);
        LearningContentBoard theTarget = this.learningContentBoardService.getById(targetId);

        if (theSource.getSortorder() > theTarget.getSortorder()) {
            moveType = "down";
        } else {
            moveType = "up";
        }
        Integer sourceSortorder = theSource.getSortorder();
        Integer targetSortorder = theTarget.getSortorder();

        boolean flag = false;
        //默认sortorder为降序排序,向上移动
        if ("up".equalsIgnoreCase(moveType) && sourceSortorder < targetSortorder) {
            flag = true;
            QueryWrapper<LearningContentBoard> wrapper = new QueryWrapper<>();
            wrapper.between("sortorder", sourceSortorder, targetSortorder);
            wrapper.select("id", "sortorder");
            List<LearningContentBoard> list = this.learningContentBoardService.list(wrapper);
            for (LearningContentBoard entity : list) {
                if (!entity.getId().equals(sourceId)) {
                    entity.setSortorder(entity.getSortorder() - 1);
                    this.learningContentBoardService.updateById(entity);
                }
            }
        }
        //默认sortorder为降序排序,向下移动
        else if ("down".equalsIgnoreCase(moveType) && sourceSortorder > targetSortorder) {
            flag = true;
            QueryWrapper<LearningContentBoard> wrapper = new QueryWrapper<>();
            wrapper.between("sortorder", targetSortorder, sourceSortorder);
            wrapper.select("id", "sortorder");
            List<LearningContentBoard> slideList = this.learningContentBoardService.list(wrapper);
            for (LearningContentBoard entity : slideList) {
                if (!entity.getId().equals(sourceId)) {
                    entity.setSortorder(entity.getSortorder() + 1);
                    this.learningContentBoardService.updateById(entity);
                }
            }
        }
        //默认sortorder为正序排序,向下移动
        else if ("down".equalsIgnoreCase(moveType) && sourceSortorder < targetSortorder) {
            flag = true;
            QueryWrapper<LearningContentBoard> wrapper = new QueryWrapper<>();
            wrapper.between("sortorder", sourceSortorder, targetSortorder);
            wrapper.select("id", "sortorder");
            List<LearningContentBoard> slideList = this.learningContentBoardService.list(wrapper);
            for (LearningContentBoard slide : slideList) {
                if (!slide.getId().equals(sourceId)) {
                    slide.setSortorder(slide.getSortorder() - 1);
                    this.learningContentBoardService.updateById(slide);
                }
            }
        }
        //默认sortorder为正序排序,向上移动
        else if ("up".equalsIgnoreCase(moveType) && sourceSortorder > targetSortorder) {
            flag = true;
            QueryWrapper<LearningContentBoard> wrapper = new QueryWrapper<>();
            wrapper.between("sortorder", targetSortorder, sourceSortorder);
            wrapper.select("id", "sortorder");
            List<LearningContentBoard> slideList = this.learningContentBoardService.list(wrapper);
            for (LearningContentBoard slide : slideList) {
                if (!slide.getId().equals(sourceId)) {
                    slide.setSortorder(slide.getSortorder() + 1);
                    this.learningContentBoardService.updateById(slide);
                }
            }
        }
        if (flag) {
            theSource.setSortorder(targetSortorder);
            this.learningContentBoardService.updateById(theSource);
            return getSuccessResult();
        }
        return getFailResult();
    }

}

