package cn.wisenergy.chnmuseum.party.web.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import cn.wisenergy.chnmuseum.party.model.TAppDirPic;
import cn.wisenergy.chnmuseum.party.service.TAppDirPicService;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 *  前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-29
 */
@Slf4j
@RestController
@RequestMapping("/tAppDirPic")
@Api(tags = {"App目录界面操作接口"})
public class TAppDirPicController extends BaseController {

    @Resource
    private TAppDirPicService tAppDirPicService;

    @PostMapping("/batchSave")
		@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:batch:save")
		@ApiOperation(value = "批量添加", notes = "批量添加")
    public Map<String, Object> batchSaveTAppDirPic(@Validated(value = {Add.class}) List<TAppDirPic> tAppDirPicList) {
        // 保存业务节点信息
        boolean result = tAppDirPicService.saveBatch(tAppDirPicList);
        // 返回操作结果
        if (result) {
            return getSuccessResult();
        } else {
            // 保存失败
            return getFailResult();
        }
    }

    @PostMapping("/save")
		@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:save")
		@ApiOperation(value = "添加", notes = "添加")
	public Map<String, Object> saveTAppDirPic(@Validated(value = {Add.class}) TAppDirPic tAppDirPic) {
        // 默认不为当前版本
        if (tAppDirPic.getIsCurrent() == null){
            tAppDirPic.setIsCurrent(0);
        }
        // 如果有其他版本是当前版本状态，将其当前版本状态取消
        QueryWrapper<TAppDirPic> qw = new QueryWrapper<>();
        qw.eq("is_current",1);
        List<TAppDirPic> currentList = tAppDirPicService.list(qw);
        if (currentList != null && currentList.size() > 0 && tAppDirPic.getIsCurrent() == 1){
            currentList.stream().forEach(c->{
                c.setIsCurrent(0);
            });
            tAppDirPicService.updateBatchById(currentList);
        }

        // 保存业务节点信息
        boolean result = tAppDirPicService.save(tAppDirPic);
        // 返回操作结果
        if (result) {
            return getSuccessResult();
        } else {
            // 保存失败
            return getFailResult();
        }
    }

    @PutMapping("/update")
		@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:update")
	    @ApiOperation(value = "修改信息", notes = "修改信息")
    public Map<String, Object> updateTAppDirPic(@Validated(value = {Update.class}) TAppDirPic tAppDirPic) {
        // 默认不为当前版本
        if (tAppDirPic.getIsCurrent() == null){
            tAppDirPic.setIsCurrent(0);
        }
        // 如果有其他版本是当前版本状态，将其当前版本状态取消
        QueryWrapper<TAppDirPic> qw = new QueryWrapper<>();
        qw.eq("is_current",1);
        List<TAppDirPic> currentList = tAppDirPicService.list(qw);
        if (currentList != null && currentList.size() > 0 && tAppDirPic.getIsCurrent() == 1){
            currentList.stream().forEach(c->{
                c.setIsCurrent(0);
            });
            tAppDirPicService.updateBatchById(currentList);
        }

        boolean flag = tAppDirPicService.updateById(tAppDirPic);
            if (flag) {
            return getSuccessResult();
        }
        return getFailResult();
    }

//	@PutMapping("/updateAuditStatus/{id}")
//	@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:update:audit:status")
//	@ApiOperation(value = "更新审核状态", notes = "更新审核状态")
//	@ApiImplicitParams(value = {
//			@ApiImplicitParam(name = "id", value = "标识ID", dataType = "String", paramType = "path"),
//			@ApiImplicitParam(name = "isCurrent", value = "是否为当前界面 0：否 1：是", paramType = "query", dataType = "String")
//	})
//	public Map<String, Object> updateStatus(@NotNull(message = "ID不能为空") @PathVariable("id") String id, @RequestParam("status") Integer isCurrent) {
//		UpdateWrapper<TAppDirPic> updateWrapper = new UpdateWrapper<>();
//		updateWrapper.eq("id", id);
//		updateWrapper.eq("is_current", isCurrent);
//		boolean flag = tAppDirPicService.update(updateWrapper);
//		if (flag) {
//		return getSuccessResult();
//		}
//		return getFailResult();
//    }

    @DeleteMapping("/delete/{id}")
		@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:delete")
		@ApiOperation(value = "根据ID删除", notes = "根据ID删除")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "id", value = "标识ID", paramType = "path", dataType = "String")
	})
    public Map<String, Object> deleteTAppDirPic(@PathVariable("id") String id) {
        boolean result = tAppDirPicService.removeById(id);
        if (result) {
            return getSuccessResult();
        }
        return getFailResult();
    }

    @GetMapping("/getList")
		@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:list")
		@ApiOperation(value = "获取全部列表(无分页)", notes = "获取全部列表(无分页)")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "isCurrent", value = "是否为当前界面 0：否 1：是", paramType = "query", dataType = "String")
	})
    public Map<String, Object> getTAppDirPicList(Integer isCurrent) {

        List<TAppDirPic> tAppDirPicList = tAppDirPicService.list(Wrappers.<TAppDirPic>lambdaQuery().eq(isCurrent != null,TAppDirPic::getIsCurrent, isCurrent));
        return getResult(tAppDirPicList);
    }

	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "isCurrent", value = "是否为当前界面 0：否 1：是", paramType = "query", dataType = "String")
	})
    @PostMapping("/getPageList")
		@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:page")
		@ApiOperation(value = "获取分页列表", notes = "获取分页列表")
    public Map<String, Object> getTAppDirPicPageList(String isCurrent) {
		LambdaQueryWrapper<TAppDirPic> queryWrapper = new LambdaQueryWrapper<>();
		// 对是否为当前界面
		if (StringUtils.isNotBlank(isCurrent)) {
			queryWrapper.eq(TAppDirPic::getIsCurrent, isCurrent);
		}

		Page<TAppDirPic> page = this.tAppDirPicService.page(getPage(), queryWrapper);
		for (TAppDirPic tAppDirPic : page.getRecords()) {

		}
		return getResult(page);
    }

    @ApiOperation(value = "获取详情", notes = "获取详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "标识ID", dataType = "String", paramType = "path")
    })
    @GetMapping("/get/{id}")
		@RequiresAuthentication  //@RequiresPermissions("t:app:dir:pic:get:id")
	    public Map<String, Object> getById(@PathVariable("id") String id) {
        TAppDirPic tAppDirPic = tAppDirPicService.getById(id);
		return getResult(tAppDirPic);
    }

}

