package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.auth.SHA256PasswordEncryptionService;
import cn.wisenergy.chnmuseum.party.auth.SecureRandomSaltService;
import cn.wisenergy.chnmuseum.party.common.log.MethodLog;
import cn.wisenergy.chnmuseum.party.common.log.OperModule;
import cn.wisenergy.chnmuseum.party.common.log.OperType;
import cn.wisenergy.chnmuseum.party.common.util.DateUtil80;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.service.impl.TUserServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import cn.wisenergy.chnmuseum.party.model.TInteraction;
import cn.wisenergy.chnmuseum.party.service.TInteractionService;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 看板互动 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-23
 */
@Slf4j
@RestController
@RequestMapping("/interaction")
@Api(tags = {"看板互动操作接口"})
public class TInteractionController extends BaseController {

    @Resource
    private TInteractionService tInteractionService;

    @Resource
    private TUserServiceImpl userService;


    @PostMapping("/add")
    @RequiresAuthentication  //@RequiresPermissions("/interaction/add")
    @ApiOperation(value = "添加看板互动", notes = "添加看板互动")
    @MethodLog(operModule = OperModule.INTERACTIVE,operType = OperType.ADD)
    public Map<String, Object> saveTInteraction(TInteraction tInteraction) {

        // 保存业务节点信息
        boolean result = false;
        try {
            Map<String, Object> resultMap = new LinkedHashMap<String, Object>();
            if (StringUtils.isBlank(tInteraction.getName())||StringUtils.isBlank(tInteraction.getPassword())) {
                resultMap.put("resultCode", "400");
                resultMap.put("message", "请输入用户名和密码");
                return resultMap;
            }
            TUser user = userService.selectByUsername(tInteraction.getName());
            if (user == null) {
                resultMap.put("resultCode", "500");
                resultMap.put("message", "用户名错误");
                return resultMap;
            }
            if (!"2".equals(user.getType())) {
                resultMap.put("resultCode", "500");
                resultMap.put("message", "用户不是单位管理员");
                return resultMap;
            }
            byte[] salt = user.getPasswordSalt();
            if (!new String(SHA256PasswordEncryptionService.createPasswordHash(tInteraction.getPassword(), salt))
                    .equals(new String(user.getPasswordHash()))) {
                resultMap.put("resultCode", "500");
                resultMap.put("message", "密码错误");
                return resultMap;
            }

            tInteraction.setCreateTime(LocalDateTime.now());
            result = tInteractionService.save(tInteraction);
            // 返回操作结果
            if (result) {
                return getSuccessResult();
            } else {
                // 保存失败
                return getFailResult();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @PutMapping("/update")
    @RequiresAuthentication  //@RequiresPermissions("/interaction/update")
    @ApiOperation(value = "修改看板互动信息", notes = "修改看板互动信息")
    @MethodLog(operModule = OperModule.INTERACTIVE,operType = OperType.UPDATE)
    public Map<String, Object> updateTInteraction(TInteraction tInteraction) {
        boolean flag = false;
        try {
            flag = tInteractionService.updateById(tInteraction);
            if (!flag) {
                return getFailResult();
            }
                return getSuccessResult();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return getFailResult();
    }


    @DeleteMapping("/delete")
    @RequiresAuthentication  //@RequiresPermissions("/interaction/delete")
    @ApiOperation(value = "根据ID删除看板互动", notes = "根据ID删除看板互动")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "id", value = "标识ID", paramType = "query", dataType = "String")
    })
    @MethodLog(operModule = OperModule.INTERACTIVE,operType = OperType.DELETE)
    public Map<String, Object> deleteTInteraction(String id) {
        boolean result = tInteractionService.removeById(id);
        if (result) {
            return getSuccessResult();
        }
        return getFailResult();
    }


    @PostMapping("/getList")
    @RequiresAuthentication  //@RequiresPermissions("/interaction/getList")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "orgId", value = "机构id", paramType = "query", dataType = "String")
    })
    @ApiOperation(value = "获取看板互动列表", notes = "获取看板互动列表")
    @MethodLog(operModule = OperModule.INTERACTIVE,operType = OperType.SELECT)
    public Map<String, Object> getTInteractionPageList(String orgId) {
        Page<TInteraction> list = null;
        try {
            list = tInteractionService.selectPageList(getPage(),orgId);
            return getResult(list);
        } catch (Exception e) {
            e.printStackTrace();
        }
       return getFailResult();
    }


    @ApiOperation(value = "获取看板互动详情", notes = "获取看板互动详情")
    @GetMapping("/getById")
    @RequiresAuthentication  //@RequiresPermissions("/interaction/getById")
    @MethodLog(operModule = OperModule.INTERACTIVE,operType = OperType.SELECT)
    public Map<String, Object> getById(String id) {
        TInteraction tInteraction = null;
        try {
            tInteraction = tInteractionService.getById(id);
            return getResult(tInteraction);
        } catch (Exception e) {
            e.printStackTrace();
        }
       return getFailResult();
    }


//	@ApiImplicitParams(value = {
//			@ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
//			@ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
//			@ApiImplicitParam(name = "nameOrCode", value = "名称或编码", paramType = "query", dataType = "String"),
//			@ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
//			@ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String")
//	})
//    @PostMapping("/getPageList")
//		@RequiresAuthentication  //@RequiresPermissions("/interaction/getPageList")
//		@ApiOperation(value = "获取看板互动分页列表", notes = "获取看板互动分页列表")
//    public Map<String, Object> getTInteractionPageList(GenericPageParam genericPageParam) {
//		LambdaQueryWrapper<TInteraction> queryWrapper = new LambdaQueryWrapper<>();
//		// 对名称或编码模糊查询
//		if (StringUtils.isNotBlank(genericPageParam.getNameOrCode())) {
//			queryWrapper.like(TInteraction::getUsername, genericPageParam.getNameOrCode());
//		}
//		// 根据创建时间区间检索
//		if (genericPageParam.getStartDate() != null && genericPageParam.getEndDate() != null) {
//			queryWrapper.ge(TInteraction::getCreateTime, genericPageParam.getStartDate().atTime(0, 0, 0))
//				.le(TInteraction::getCreateTime, genericPageParam.getEndDate().atTime(23, 59, 59));
//		}
//		// 设置排序规则
//		queryWrapper.orderByDesc(TInteraction::getCreateTime);
//		Page<TInteraction> page = this.tInteractionService.page(getPage(), queryWrapper);
//		for (TInteraction tInteraction : page.getRecords()) {
//
//		}
//		return getResult(page);
//    }


}

