package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;
import cn.wisenergy.chnmuseum.party.model.CopyrightOwner;
import cn.wisenergy.chnmuseum.party.model.VideoContent;
import cn.wisenergy.chnmuseum.party.model.VideoContentCat;
import cn.wisenergy.chnmuseum.party.service.CopyrightOwnerService;
import cn.wisenergy.chnmuseum.party.service.VideoContentCatService;
import cn.wisenergy.chnmuseum.party.service.VideoContentService;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <pre>
 * 视频内容分类 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-17
 */
@Slf4j
@RestController
@RequestMapping("/videoContentCat")
@Api(tags = {"视频内容分类接口"})
public class VideoContentCatController extends BaseController {

    @Resource
    private VideoContentCatService videoContentCatService;

    @Resource
    private VideoContentService videoContentService;

    @Resource
    private CopyrightOwnerService copyrightOwnerService;

    @PostMapping(value = "/save")
    @RequiresAuthentication  //@RequiresPermissions("video:content:cat:save")
    @ApiOperation(value = "添加视频内容分类", notes = "添加视频内容分类")
    public Map<String, Object> saveVideoContentCat(@Validated(value = {Add.class}) VideoContentCat videoContentCat) {
        // 保存业务节点信息
        boolean result = videoContentCatService.save(videoContentCat);
        // 返回操作结果
        if (result) {
            return getSuccessResult();
        } else {
            // 保存失败
            return getFailResult();
        }
    }

    @PutMapping(value = "/update")
    @ApiOperation(value = "修改视频内容分类信息", notes = "修改视频内容分类信息")
    public Map<String, Object> updateVideoContentCat(@Validated VideoContentCat videoContentCat) {
        boolean flag = videoContentCatService.updateById(videoContentCat);
        if (flag) {
            return getSuccessResult();
        }
        return getFailResult();
    }

    @GetMapping("/getList")
    @RequiresAuthentication  //@RequiresPermissions("video:content:cat:list")
    @ApiOperation(value = "获取视频内容分类全部列表(无分页)", notes = "获取视频内容分类全部列表(无分页)")
    public Map<String, Object> getVideoContentCatList() {
        LambdaQueryWrapper<VideoContentCat> queryWrapper = new LambdaQueryWrapper<>();
        // 设置排序规则
        List<VideoContentCat> videoContentCatList = videoContentCatService.list(Wrappers.<VideoContentCat>lambdaQuery().orderByDesc(VideoContentCat::getCreateTime));
        return getResult(videoContentCatList);
    }

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "nameOrCode", value = "名称或编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String")
    })
    @PostMapping("/getPageList")
    @RequiresAuthentication  //@RequiresPermissions("video:content:cat:page")
    @ApiOperation(value = "获取视频内容分类分页列表", notes = "获取视频内容分类分页列表")
    public Map<String, Object> getVideoContentCatPageList(GenericPageParam genericPageParam) {
        LambdaQueryWrapper<VideoContentCat> queryWrapper = new LambdaQueryWrapper<>();
        // 对名称或编码模糊查询
        if (StringUtils.isNotBlank(genericPageParam.getNameOrCode())) {
            queryWrapper.like(VideoContentCat::getName, genericPageParam.getNameOrCode());
        }
        // 根据创建时间区间检索
        if (genericPageParam.getStartDate() != null && genericPageParam.getEndDate() != null) {
            queryWrapper.ge(VideoContentCat::getCreateTime, genericPageParam.getStartDate().atTime(0, 0, 0))
                    .le(VideoContentCat::getCreateTime, genericPageParam.getEndDate().atTime(23, 59, 59));
        }
        // 设置排序规则
        queryWrapper.orderByDesc(VideoContentCat::getCreateTime);
        // 设置查询内容
        queryWrapper.select(
                VideoContentCat::getId,
                VideoContentCat::getName,
                VideoContentCat::getCreateTime,
                VideoContentCat::getUpdateTime);
        Page<VideoContentCat> page = this.videoContentCatService.page(getPage(), queryWrapper);
        for (VideoContentCat videoContentCat : page.getRecords()) {
            LambdaQueryWrapper<VideoContent> lambdaQueryWrapper = Wrappers.<VideoContent>lambdaQuery().eq(VideoContent::getVideoContentCatId, videoContentCat.getId());
            lambdaQueryWrapper = lambdaQueryWrapper.select(VideoContent::getId).select(VideoContent::getVideoContentCopyrightOwnerId);
            List<VideoContent> videoContentList = this.videoContentService.list(lambdaQueryWrapper);
            if (!videoContentList.isEmpty()) {
                final Set<String> videoContentCopyrightOwnerIdList = videoContentList.stream().map(VideoContent::getVideoContentCopyrightOwnerId).collect(Collectors.toSet());
                List<CopyrightOwner> copyrightOwnerList = this.copyrightOwnerService.listByIds(videoContentCopyrightOwnerIdList);
                String copyrightOwnerName = copyrightOwnerList.stream().map(CopyrightOwner::getName).collect(Collectors.joining("、"));
                videoContentCat.setCopyrightOwnerName(copyrightOwnerName);
            }
        }
        return getResult(page);
    }

    @ApiOperation(value = "获取视频内容分类详情", notes = "获取视频内容分类详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "标识ID", dataType = "String", paramType = "path")
    })
    @GetMapping("/get/{id}")
    @RequiresAuthentication  //@RequiresPermissions("video:content:cat:get:id")
    public Map<String, Object> getById(@PathVariable("id") String id) {
        VideoContentCat videoContentCat = videoContentCatService.getById(id);
        return getResult(videoContentCat);
    }

}

