package cn.wisenergy.chnmuseum.party.web.controller.base;

import cn.wisenergy.chnmuseum.party.auth.util.JwtTokenUtil;
import cn.wisenergy.chnmuseum.party.common.enums.RESPONSE_CODE_ENUM;
import cn.wisenergy.chnmuseum.party.common.enums.RESULT_INFO_ENUM;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.service.TUserService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * controller 基类控制器
 */
public class BaseController implements Serializable {

    private static final long serialVersionUID = 624841049563451448L;
    protected static final Logger logger = LoggerFactory.getLogger(BaseController.class);


    @Resource
    protected HttpServletRequest request;

    @Resource
    protected TUserService userService;

    /**
     * <p>
     * 获取分页对象
     * </p>
     */
    protected <T> Page<T> getPage() {
        return getPage(10L);
    }

    protected <T> Page<T> getPage(long size) {
        long _size = size, _index = 1;
        if (request.getParameter("_size") != null) {
            _size = Integer.parseInt(request.getParameter("_size"));
        }
        if (request.getParameter("_index") != null) {
            _index = Integer.parseInt(request.getParameter("_index"));
        }
        return new Page<>(_index, _size);
    }

    /**
     * 添加数据到结果对象中
     *
     * @param obj 封装接口集合参数
     * @return map
     */
    protected Map<String, Object> getResult(Object obj) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put(RESULT_INFO_ENUM.RESULT_CODE.getKey(), RESPONSE_CODE_ENUM.REQUEST_SUCCESS.getResultCode());
        map.put(RESULT_INFO_ENUM.RESULT_MSG.getKey(), RESPONSE_CODE_ENUM.REQUEST_SUCCESS.getMessage());
        map.put(RESULT_INFO_ENUM.RESULT_BODY.getKey(), obj);
        return map;
    }

    /**
     * 返回成功
     *
     * @return map
     */
    protected Map<String, Object> getSuccessResult() {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put(RESULT_INFO_ENUM.RESULT_CODE.getKey(), RESPONSE_CODE_ENUM.REQUEST_SUCCESS.getResultCode());
        map.put(RESULT_INFO_ENUM.RESULT_MSG.getKey(), RESPONSE_CODE_ENUM.REQUEST_SUCCESS.getMessage());
        map.put(RESULT_INFO_ENUM.RESULT_BODY.getKey(),"");
        return map;
    }

    /**
     * 返回失败
     *
     * @param code 状态码
     * @param msg  失败原因
     * @return map
     */
    protected Map<String, Object> getFailResult(String code, String msg) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put(RESULT_INFO_ENUM.RESULT_CODE.getKey(), code);
        map.put(RESULT_INFO_ENUM.RESULT_MSG.getKey(), msg);
        return map;
    }

    /**
     * 返回失败
     *
     * @param responseCodeEnum 特定状态码
     * @return map
     */
    protected Map<String, Object> getFailResult(RESPONSE_CODE_ENUM responseCodeEnum) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put(RESULT_INFO_ENUM.RESULT_CODE.getKey(), responseCodeEnum.getResultCode());
        map.put(RESULT_INFO_ENUM.RESULT_MSG.getKey(), responseCodeEnum.getMessage());
        return map;
    }

    /**
     * 返回失败
     *
     * @return map
     */
    protected Map<String, Object> getFailResult() {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put(RESULT_INFO_ENUM.RESULT_CODE.getKey(), RESPONSE_CODE_ENUM.SERVER_ERROR.getResultCode());
        map.put(RESULT_INFO_ENUM.RESULT_MSG.getKey(), RESPONSE_CODE_ENUM.SERVER_ERROR.getMessage());
        return map;
    }

    /**
     * 返回失败
     *
     * @return map
     */
    protected Map<String, Object> getFailResult(String msg) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put(RESULT_INFO_ENUM.RESULT_CODE.getKey(), RESPONSE_CODE_ENUM.SERVER_ERROR.getResultCode());
        map.put(RESULT_INFO_ENUM.RESULT_MSG.getKey(), msg);
        return map;
    }

    /**
     * JSON 过滤相关字段
     *
     * @param obj          待过滤的对象
     * @param propertyList 需要过滤掉的字段集合
     * @return 过滤后的JSON结果
     */
    protected String propertyFilter(Object obj, List<String> propertyList) {
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter();
        for (String params : propertyList) {
            filter.getExcludes().add(params);
        }
        return JSONObject.toJSONString(obj, filter);
    }

    /**
     * JSON 过滤相关字段，并保持结果为JSON对象
     *
     * @param obj          待过滤的对象
     * @param propertyList 需要过滤掉的字段集合
     * @return 过滤后的JSON对象结果
     */
    protected JSONObject propertyFilterToJsonObject(Object obj, List<String> propertyList) {
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter();
        for (String params : propertyList) {
            filter.getExcludes().add(params);
        }
        return JSONObject.parseObject(JSONObject.toJSONString(obj, filter));
    }

    /**
     * JSON 过滤相关字段，并保持结果为JSON数组
     *
     * @param obj          待过滤的对象
     * @param propertyList 需要过滤掉的字段集合
     * @return 过滤后的JSON数组结果
     */
    protected JSONArray propertyFilterToJsonArray(Object obj, List<String> propertyList) {
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter();
        for (String params : propertyList) {
            filter.getExcludes().add(params);
        }
        return JSONObject.parseArray(JSONObject.toJSONString(obj, filter));
    }

    /**
     * <p>
     * 根据token信息
     * </p>
     */
    protected String getUserId() {
        String authorization = request.getHeader("Authorization");
        if (StringUtils.isNotBlank(authorization)) {
            if (authorization.startsWith("Bearer ")) {
                authorization = authorization.substring(7);
            }
        }else {
            throw new AuthenticationException("token失效,请重新登录");
        }
        return JwtTokenUtil.getEmployeeId(authorization);
    }

    /**
     * <p>
     * 根据token信息
     * </p>
     */
    protected String getUserName() {
        String authorization = request.getHeader("Authorization");
        if (StringUtils.isNotBlank(authorization)) {
            if (authorization.startsWith("Bearer ")) {
                authorization = authorization.substring(7);
            }
        }else {
            throw new AuthenticationException("token失效,请重新登录");
        }
        return JwtTokenUtil.getUsername(authorization);
    }

    /**
     * <p>
     * 根据token信息获取当前用户
     * </p>
     */
    protected TUser getcurUser() {
        String userName = getUserName();
        TUser user = userService.selectByUsername(userName);
        return user;
    }

}
