package cn.wisenergy.common.constant;

public interface IscCameraConstants {

    /**
     * 查询编码设备列表v2
     * 根据条件查询目录下有权限的编码设备列表。当返回字段对应的值为空时，该字段不返回。
     * 综合安防管理平台iSecure Center V1.4及以上版本
     */
    String encodeDevice_search = "";

    /**
     * 根据区域编码、资源操作权限码分页获取当前区域下（不包含子区域）有权限的编码设备列表，主要用于逐层获取区域下的编码设备信息。
     * 综合安防管理平台iSecure Center v1.3及以上版本
     */
    String encodeDevice_subResources = "/api/resource/v1/encodeDevice/subResources";

    /**
     * 根据编号获取监控点详细信息
     * 获取单个监控点信息是指根据监控点唯一标识来获取指定的监控点信息。
     */
    String cameras_indexCode = "/api/resource/v1/cameras/indexCode";

    /**
     * 分页获取监控点资源
     */
    String cameras = "/api/resource/v1/cameras";

    /**
     * 获取监控点预览取流URLv2
     * 综合安防管理平台iSecure Center V1.4及以上版本
     */
    String previewURLs = "/api/video/v2/cameras/previewURLs";

    /**
     * 获取监控点回放取流URLv2
     * 综合安防管理平台iSecure Center V1.4及以上版本
     */
    String playbackURLs = "/api/video/v2/cameras/playbackURLs";

    /**
     * 查询对讲URL
     * 该接口用于获取监控点的对讲url，为保证数据的安全性，URL设有有效时间，有效时间为5分钟。
     * 综合安防管理平台iSecure Center V1.2及以上版本
     */
    String talkURLs = "/api/video/v1/cameras/talkURLs";

    /**
     * 手动抓图
     * 该接口用于手动触发设备抓图，返回图片的地址，抓图前请确保平台上已配置图片存储信息。抓图时间为触发手动抓图命令的时间。
     * 综合安防管理平台iSecure Center V1.2及以上版本
     */
    String manualCapture = "/api/video/v1/manualCapture";

    /**
     * 通过向中心存储接入服务下发锁定/解锁指定编码器，指定时间段的录像。
     * 综合安防管理平台iSecure Center V1.4及以上版本
     */
    String lock = "/api/video/v1/record/lock";


    /**
     * 开始手动录像
     * 综合安防管理平台iSecure Center V1.3及以上版本
     */
    String manualRecordStart = "/api/video/v1/manualRecord/start";

    /**
     * 停止手动录像
     * 综合安防管理平台iSecure Center V1.5及以上版本
     */
    String manualRecordStop = "/api/video/v1/manualRecord/stop";

    /**
     * 获取手动录像状态
     * 综合安防管理平台iSecure Center V1.5及以上版本
     */
    String manualRecordStatus = "/api/video/v1/manualRecord/status";

    /**
     * 查询手动录像编号
     * 该接口用于根据用户id获取当前用户创建的手动录像任务ID，用于获取手动录像状态和停止手动录像
     */
    String manualRecordSearch = "/api/video/v1/manualRecord/taskId/search";

    /**
     * 根据区域编号获取下一级区域列表v2
     */
    String regionsSubRegions = "/api/resource/v2/regions/subRegions";


    /**
     * 获取根区域信息
     */
    String regionsRoot = "/api/resource/v1/regions/root";

    /**
     * 查询区域列表v2
     */
    String regionNodes = "/api/irds/v2/region/nodesByParams";

    /**
     * 根据区域编号获取下级监控点列表
     */
    String regionIndexCodeCameras = "/api/resource/v1/regions/regionIndexCode/cameras";

    /**
     * 获取监控点在线状态
     */
    String onlineCamera = "/api/nms/v1/online/camera/get";

    /**
     * 获取编码设备在线状态
     */
    String onlineEncodeDevice = "/api/nms/v1/online/encode_device/get";


}
