package cn.wisenergy.mapper;

import cn.wisenergy.model.app.OrderInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author 86187
 */
public interface OrderMapper extends BaseMapper<OrderInfo> {

    /**
     * 根据返佣状态获取 订单列表
     *
     * @param rebateStatus 0 未返佣  1 返佣
     * @return 订单列表
     */
    List<OrderInfo> getByRebateStatus(@Param("rebateStatus") Integer rebateStatus);

    /**
     * 有赞订单数据插入
     */
    void insertYouZanOrders(OrderInfo orderInfo);

    /**
     * 根据tid获取订单数据
     *
     * @param tid 有赞生成的订单id
     * @return 一条订单数据
     */
    OrderInfo getByTid(@Param("tid") String tid);

    /**
     * 获取当前用户的业绩
     *
     * @param userId
     * @return
     */
    BigDecimal getPerformanceByUserid(String userId);

    /**
     * 获取订单完成时间不为空，且订单完成时间小于当前时间
     *
     * @param successTime 订单完成时间
     * @return 订单列表
     */
    List<OrderInfo> getListBySuccessTime(@Param("successTime") Date successTime);

    /**
     * 更据创建订单时间获取订单列表
     * @param created 创建订单时间
     * @return 订单列表
     */
    List<OrderInfo> getByCreateTime(@Param("created") Date created);

    List<OrderInfo> getByLevelStatus(int levelStatus);
}
