package cn.wisenergy.mapper;

import cn.wisenergy.model.app.TeamPerformance;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * @author 86187
 */
public interface TeamPerformanceMapper extends BaseMapper<TeamPerformance> {

    int add(TeamPerformance teamPerformance);

    /**
     * 编辑
     * @param teamPerformance 团队业绩
     * @return 1
     */
    int edit(TeamPerformance teamPerformance);

    int delById(@Param("id") Integer id);

    /**
     * 用户id和时间获取用户月业绩
     *
     * @param userId    用户id
     * @param yearMonth 时间
     * @return 用户月业绩
     */
    TeamPerformance getByUserIdAndTime(@Param("userId") String userId, @Param("yearMonth") String yearMonth);

    /**
     * 统计 等级月业绩和
     *
     * @param userLevel 等级
     * @param yearMonth 年月
     * @return 等级总金额
     */
    Double countTeamMoney(@Param("userLevel") Integer userLevel, @Param("yearMonth") String yearMonth);

    /**
     * 获取时间前的 月业绩列表
     *
     * @param yearMonth 时间
     * @return 月业绩列表
     */
    List<TeamPerformance> getByBeforeTime(@Param("yearMonth") String yearMonth);

    /**
     * 根据时间统计 所有用户业绩和
     *
     * @param yearMonth 时间
     * @return 所有用户业绩和
     */
    Double countByTime(@Param("yearMonth") String yearMonth);

    /**
     * 月业绩排名前20人 业绩和
     * @param yearMonth 时间
     * @return 业绩和
     */
    Double countTwenty(@Param("yearMonth") String yearMonth);

    List<TeamPerformance> userTwenty(@Param("yearMonth") String yearMonth);

    /**
     * 当前用户的团队总业绩
     * @param userId 当前用户id
     * @return 当前用户的团队累计总业绩金额
     */
    Double countUserTeamByUserId(@Param("userId") String userId);

    /**
     * 当前用户本月团队新增业绩
     * @param userId 用户Id
     * @return 当前用户本月团队新增业绩
     */
    Double monthUserTeamByuserId(@Param("userid") String userId,@Param("yearMonth") String yearMonth);

}
