package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 86187
 * @ Description: 会员等级优惠百分比
 * @ Author     : 86187
 * @ Date       : 2021/2/22 11:05
 */
@Data
@ApiModel("MemberPercent")
public class MemberPercent implements Serializable {
    private static final long serialVersionUID = -3829843983637924282L;
    /**
     * 返佣id
     */
    @ApiModelProperty(name = "id", value = "返佣id")
    private Integer id;

    /**
     * 用户会员等级 0:普通用户 1：幼苗 2：青铜树 3：白银树 4：黄金树 5：农场主 6：森林之星 7:西田森合伙人
     */
    @ApiModelProperty(name = "userLevel", value = "用户会员等级")
    private Integer userLevel;
    /**
     * 会员等级百分比类型：1：返佣 2：月度肥料 3：月度最大进步奖 4：运营中心补贴
     */
    @ApiModelProperty(name = "type", value = "会员等级百分比类型：1：返佣 2：月度肥料 3：月度最大进步奖 4：运营中心补贴")
    private Integer type;

    /**
     * 等级对应的返佣比例
     */
    @ApiModelProperty(name = "", value = "")
    private BigDecimal percent;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "", value = "")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(name = "", value = "")
    private Date updateTime;
}
