package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 86187
 * @ Description: 月度奖金页面展示数据Vo
 * @ Author     : 86187
 * @ Date       : 2021/3/9 11:09
 */
@ApiModel("MonthAwardVo")
@Data
public class MonthAwardVo {

    /**
     * 与上一次比较的增长奖金
     */
    @ApiModelProperty(name = "growthAward", value = "与上一次比较的增长额度")
    private Double growthAward;

    /**
     * 历史奖金总额
     */
    @ApiModelProperty(value = "历史奖金总额",name="awardTotal")
    private Double awardTotal;

    /**
     * 本月累计奖金总额（本月新增+上月没有分出去的月度肥料奖金）
     */
    @ApiModelProperty(value = "本月累计奖金总额",name="monthAwardTotal")
    private Double monthAwardTotal;

    /**
     * 本月新增
     */
    @ApiModelProperty(value = "本月新增",name="monthIncreased")
    private Double monthIncreased;

    /**
     * 黄金树月奖励总额
     */
    @ApiModelProperty(value = "黄金树月奖励总额",name="goldAward")
    private Double goldAward;


    /**
     * 农场主月奖励总额
     */
    @ApiModelProperty(value = "农场主月奖励总额",name="farmerAward")
    private Double farmerAward;

    /**
     * 森林之星月奖励总额
     */
    @ApiModelProperty(value = "森林之星月奖励总额",name="forestStartAward")
    private Double forestStartAward;

    /**
     * 森田合伙人月奖励总额
     */
    @ApiModelProperty(value = "森田合伙人月奖励总额",name="partnerAward")
    private Double partnerAward;

    /**
     * 用户-份额
     */
    @ApiModelProperty(value = "用户-份额", name = "userMonthAward")
    private Double userMonthAward;

    /**
     * 奖金入池时间
     */
    @ApiModelProperty(value = "奖金入池时间", name = "awardTime")
    private Date awardTime;
}
