package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.MonthAwardMapper;
import cn.wisenergy.mapper.TradeRecordMapper;
import cn.wisenergy.model.app.MonthAward;
import cn.wisenergy.model.vo.MonthAwardVo;
import cn.wisenergy.service.app.MonthAwardService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author 86187
 */
@Slf4j
@Service
public class MonthAwardServiceImpl extends ServiceImpl<MonthAwardMapper, MonthAward> implements MonthAwardService {
    private static final String PATTERN = "yyyy-MM";

    @Autowired
    private TradeRecordMapper tradeRecordMapper;

    @Override
    public R<MonthAwardVo> queryMonthAward(String userId) {
        log.info("shop-mall[]MonthAwardServiceImpl[]queryMonthAward[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参为空!");
        }

        //获取本月最新的一条数据
        MonthAwardVo monthAwardVo = new MonthAwardVo();
        MonthAward monthAward = baseMapper.getByTime(new Date());
        if (null == monthAward) {
            return R.ok(monthAwardVo);
        }

        monthAwardVo.setAwardTime(monthAward.getCreateTime());
        monthAwardVo.setAwardTotal(monthAward.getAwardTotal());
        monthAwardVo.setFarmerAward(monthAward.getFarmerAward());
        monthAwardVo.setForestStartAward(monthAward.getForestStartAward());
        monthAwardVo.setGoldAward(monthAward.getGoldAward());
        monthAwardVo.setGrowthAward(monthAward.getGrowthAward());
        monthAwardVo.setMonthAwardTotal(monthAward.getMonthAwardTotal());
        monthAwardVo.setMonthIncreased(monthAward.getMonthIncreased());
        monthAwardVo.setPartnerAward(monthAward.getPartnerAward());

        //获取用户本月奖金
        Double sum = tradeRecordMapper.queryMonthAward(userId, new Date());
        if (null == sum) {
            monthAwardVo.setUserMonthAward(0.00);
        } else {
            monthAwardVo.setUserMonthAward(sum);
        }
        return R.ok(monthAwardVo);
    }
}
