package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.mapper.MonthAwardMapper;
import cn.wisenergy.mapper.MonthManureMapper;
import cn.wisenergy.mapper.TradeRecordMapper;
import cn.wisenergy.model.app.MonthAward;
import cn.wisenergy.model.app.MonthManure;
import cn.wisenergy.model.app.TradeRecord;
import cn.wisenergy.model.enums.UserLevelEnum;
import cn.wisenergy.service.app.TradeRecordService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author 86187
 */
@Service
@Slf4j
public class TradeRecordServiceImpl extends ServiceImpl<TradeRecordMapper, TradeRecord> implements TradeRecordService {
    @Autowired
    private MonthManureMapper monthManureMapper;

    @Autowired
    private MonthAwardMapper monthAwardMapper;

    @Override
    public Boolean monthAwardCount() {
        MonthAward result = new MonthAward();
        //1、获取本月新增奖金
        Double monthGrow = baseMapper.queryMonthGrow(new Date());
        result.setMonthIncreased(monthGrow);

        //2、获取历史奖金金额
        Double awardTotal = baseMapper.queryAllAward(new Date());
        result.setAwardTotal(awardTotal);

        //3、本月累计奖金 =本月新增奖金+上月剩余月度肥料奖金
        //获取上月剩余月度肥料奖金
        Double monthAwardTotal;
        Date date = DateUtil.getLastMonth(new Date());
        String yearMonth = DateUtil.convertDateToStr(date, "yyyy-MM");
        MonthManure monthManure = monthManureMapper.queryByTime(yearMonth);
        if (null == monthManure) {
            monthAwardTotal = monthGrow;
        } else {
            monthAwardTotal = monthGrow + monthManure.getManureAward();
        }
        result.setMonthAwardTotal(monthAwardTotal);

        //4、较上月增长奖金  本月累计奖金-上月累计奖金
        //获取上月 累计奖金
        Double growthAward;
        MonthAward monthAward = monthAwardMapper.getByTime(date);
        if (null == monthAward) {
            growthAward = monthAwardTotal;
        } else {
            growthAward = monthAwardTotal - monthAward.getMonthAwardTotal();
        }
        result.setGrowthAward(growthAward);

        //5、获取黄金树本月奖金
        Double goldAward = baseMapper.queryByUserLevel(UserLevelEnum.GOLD_TREE.getCode(), new Date());
        result.setGoldAward(goldAward);

        //6、获取农场主本月奖金
        Double farmerAward = baseMapper.queryByUserLevel(UserLevelEnum.FARMER.getCode(), new Date());
        result.setFarmerAward(farmerAward);

        //7、森林之星月奖金
        Double startAward = baseMapper.queryByUserLevel(UserLevelEnum.FOREST_START.getCode(), new Date());
        result.setForestStartAward(startAward);

        //8、森田合伙人月奖金
        Double partnerAward = baseMapper.queryByUserLevel(UserLevelEnum.PARTNER.getCode(), new Date());
        result.setPartnerAward(partnerAward);

        //9、 判断是否有本月奖金这条数据，没有，新增，有更新值
        MonthAward currentMonth = monthAwardMapper.getByTime(new Date());
        if (null == currentMonth) {
            int count = monthAwardMapper.add(result);
            return count != 0;
        } else {
            int count = monthAwardMapper.edit(result);
            return count != 0;
        }
    }
}
