package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.PrizeShowVo;
import cn.wisenergy.service.app.ProgressPrizeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author 86187
 */
@Api(tags = "进步奖相关接口")
@RestController
@RequestMapping("/growth")
@Slf4j
public class ProgressPrizeController {
    @Autowired
    private ProgressPrizeService progressPrizeService;

    @ApiOperation(value = "获取本月进步奖列表", notes = "获取本月进步奖列表", httpMethod = "GET")
    @GetMapping("/getProgressPrizes")
    public R<PrizeShowVo> getProgressPrizes() {
        log.info("shop-mall[]ProgressPrizeController[]getProgressPrizes[]input.method");
        return progressPrizeService.getProgressPrizes();
    }
}
