package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.constant.RedisConsts;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.common.utils.RedisUtils;
import cn.wisenergy.model.app.RecommendUser;
import cn.wisenergy.model.app.TeamUserInfo;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.vo.AerialDeliveryVo;
import cn.wisenergy.model.vo.UserAndRecommendVo;
import cn.wisenergy.service.app.RecommendUserService;
import cn.wisenergy.service.app.TeamUserInfoService;
import cn.wisenergy.service.app.UserForestStatusService;
import cn.wisenergy.service.app.UserService;
import cn.wisenergy.web.common.BaseController;
import cn.wisenergy.web.config.JwtConfig;
import cn.wisenergy.web.shiro.JwtUtil;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author 86187
 */
@Api(tags = "用户管理")
@RestController
@RequestMapping("/user")
@Slf4j
public class UserController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private UserForestStatusService userForestStatusService;

    @Autowired
    RecommendUserService recommendUserService;

    @Autowired
    TeamUserInfoService teamUserInfoService;

    @Autowired
    private JwtUtil jwtUtil;

    @Autowired
    private JwtConfig jwtConfig;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private RedisUtils redisUtils;

    @ApiOperation(value = "获取用户信息", notes = "获取用户信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/getByUserId")
    public User getByUserId(String userId) {
        return userService.getById(userId);
    }

    /**
     * shiro登录
     *
     * @return
     */
    @ApiOperation(value = "获取token接口", notes = "获取token接口", httpMethod = "POST")
    @PostMapping(value = "/login")
    public R<String> login(String id) {
        if (null == id) {
            return R.error("入参为空!");
        }

        //用户信息
        User user = userService.getByUserId(id);

        // 创建token
        String token = jwtUtil.generateToken(user);
        // 保存Redis
        redisTemplate.opsForValue().set(RedisConsts.JWT_ACCESS_TOKEN + token, token);
        return R.ok(token);
    }

    @ApiOperation(value = "获取用户森林状态接口", notes = "获取用户森林状态接口", httpMethod = "GET")
    @GetMapping("/forestStatus")
    public R<Map> forestStatus(String userId) {
        if (null == userId) {
            return R.error("入参为空");
        }

        try {
            Map userForestStatus = userForestStatusService.getUserForestStatus(userId);
            return R.ok(userForestStatus);
        } catch (Exception e) {
            return R.error(1, "请重新尝试");
        }
    }

    @ApiOperation(value = "获取用户我的直推信息", notes = "获取用户我的直推信息", httpMethod = "GET")
    @GetMapping("/myRecommend")
    public R<Map> getMyRecommend(String userId) {
        //用户id
        int userLevel = userService.getByUserId(userId).getUserLevel();
        //用户各等级人数
        RecommendUser myRecommed = recommendUserService.getMyRecommed(userId);
        Map myRecommedMap = new HashMap();
        myRecommedMap.put("userlevel", userLevel);
        myRecommedMap.put("myRecommed", myRecommed);
        return R.ok(myRecommedMap);
    }

    @ApiOperation(value = "获取用户我的团队信息", notes = "获取用户我的团队推信息", httpMethod = "GET")
    @GetMapping("/myTeam")
    public R<TeamUserInfo> getMyTeam(String userId) {
        TeamUserInfo myTeam = teamUserInfoService.getOneById(userId);
        return R.ok(myTeam);
    }

    @ApiOperation(value = "获取用户我的直推信息详情", notes = "获取用户我的直推信息详情", httpMethod = "GET")
    @GetMapping("/myRecommendInfo")
    public R<List<UserAndRecommendVo>> getMyRecommendInfo(@RequestParam("userId") String userId, @RequestParam("userlevel") int userlevel) {
        List<UserAndRecommendVo> myRecommendInfo = recommendUserService.getMyRecommendInfo(userId, userlevel);
        return R.ok(myRecommendInfo);
    }

    @ApiOperation(value = "查询空投池信息", notes = "查询空投池信息", httpMethod = "GET")
    @GetMapping("/queryAerialDelivery")
    public R<AerialDeliveryVo> queryAerialDelivery() {
        log.info("shop-mall[]UserController[]queryAerialDelivery[]input.method");

        return userService.queryAerialDelivery();
    }


    @ApiOperation(value = "设置头像", notes = "设置头像", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String"),
            @ApiImplicitParam(name = "headImage", value = "头像Url", dataType = "String")
    })
    @PostMapping("/setHeadImage")
    public R<Boolean> setHeadImage(String userId, String headImage) {
        log.info("shop-mall[]UserController[]setHeadImage[]input.param.userId,headImage:" + userId, headImage);
        if (StringUtils.isBlank(userId) || StringUtils.isBlank(headImage)) {
            return R.error("入参不能为空!");
        }

        return userService.setHeadImage(userId, headImage);
    }

    @ApiOperation(value = "设置页面-邀请码填写", notes = "设置页面-邀请码填写", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String"),
            @ApiImplicitParam(name = "inviteCode", value = "邀请码", dataType = "String")
    })
    @PostMapping("/fillInInviteCode")
    public R<Boolean> fillInInviteCode(String userId, String inviteCode) {
        log.info("shop-mall[]UserController[]fillInInviteCode[]input.param.userId,inviteCode:" + userId, inviteCode);
        if (StringUtils.isBlank(userId) || StringUtils.isBlank(inviteCode)) {
            return R.error("入参不能为空!");
        }

        return userService.fillInInviteCode(userId, inviteCode);
    }

//    @GetMapping("/registUser")
//    public void registUserInit(String userId){
//        userService.registUserMoudleInit(userId);
//    }

}
