package cn.wisenergy.mapper;

import cn.wisenergy.model.app.RecommendUser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zw
 */
public interface RecommendUserMapper extends BaseMapper<RecommendUser> {

    /**
     * 获取用户直推信息
     * @param userId 用户Id
     * @return 用户直推信息
     */
    RecommendUser getByUserId(String userId);

    //根据用户推荐人的userid,查询数据库用户直推表，看推荐人用户是否存在
    Integer zcByUserId(String userid);


    /**
     * 获取用户的直推用户总人数
     * @param userId 用户Id
     * @return 直推用户总人数
     */
    Integer getRecommendUserCountByUserId(String userId);

    /**
     * 新增用户直推信息
     * @param recommendUser
     * @return
     */
    int add(RecommendUser recommendUser);
}
