package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.ProgressPrizeMapper;
import cn.wisenergy.model.app.ProgressPrize;
import cn.wisenergy.model.vo.PrizeShowVo;
import cn.wisenergy.model.vo.ProgressPrizeVo;
import cn.wisenergy.service.app.ProgressPrizeService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * @author 86187
 */
@Service
@Slf4j
public class ProgressPrizeServiceImpl extends ServiceImpl<ProgressPrizeMapper, ProgressPrize> implements ProgressPrizeService {

    @Override
    public R<PrizeShowVo> getProgressPrizes() {
        log.info("shop-mall[]ProgressPrizeServiceImpl[]getProgressPrizes[]input.method");
        //获取本月进步奖 列表
        Date date = new Date();
        String yearMonth = DateUtil.convertDateToStr(date, "yyyy-MM");
        List<ProgressPrizeVo> list = baseMapper.getByTime(yearMonth);
        if (CollectionUtils.isEmpty(list)) {
            return R.ok(new PrizeShowVo());
        }

        double sum = 0.0;
        for (ProgressPrizeVo prizeVo : list) {
            sum = sum + prizeVo.getAwardMoney();
        }
        PrizeShowVo prizeShowVo = new PrizeShowVo();
        prizeShowVo.setGrowthTotal(sum);
        prizeShowVo.setPrizeVos(list);
        return R.ok(prizeShowVo);
    }
}
