//package cn.wisenergy.service.app.impl;
//
//import cn.wisenergy.common.enums.LikedStatusEnum;
//import cn.wisenergy.common.utils.RedisKeyUtils;
//import com.solo.coderiver.user.dataobject.UserLike;
//import com.solo.coderiver.user.dto.LikedCountDTO;
//import com.solo.coderiver.user.enums.LikedStatusEnum;
//import com.solo.coderiver.user.service.LikedService;
//import com.solo.coderiver.user.service.RedisService;
//import com.solo.coderiver.user.utils.RedisKeyUtils;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.redis.core.Cursor;
//import org.springframework.data.redis.core.RedisTemplate;
//import org.springframework.data.redis.core.ScanOptions;
//import org.springframework.stereotype.Service;
//
//import java.util.ArrayList;
//import java.util.List;
//import java.util.Map;
//
///**
// * Created by m1991 on 2021/3/12 16:58
// */
//@Service
//@Slf4j
//public class RedisServiceImpl {
//    @Autowired
//    RedisTemplate redisTemplate;
//
//    @Autowired
//    LikedService likedService;
//
//    @Override
//    public void saveLiked2Redis(String likedUserId, String likedPostId) {
//        String key = RedisKeyUtils.getLikedKey(likedUserId, likedPostId);
//        redisTemplate.opsForHash().put(RedisKeyUtils.MAP_KEY_USER_LIKED, key, LikedStatusEnum.LIKE.getCode());
//    }
//
//    @Override
//    public void unlikeFromRedis(String likedUserId, String likedPostId) {
//        String key = RedisKeyUtils.getLikedKey(likedUserId, likedPostId);
//        redisTemplate.opsForHash().put(RedisKeyUtils.MAP_KEY_USER_LIKED, key, LikedStatusEnum.UNLIKE.getCode());
//    }
//
//    @Override
//    public void deleteLikedFromRedis(String likedUserId, String likedPostId) {
//        String key = RedisKeyUtils.getLikedKey(likedUserId, likedPostId);
//        redisTemplate.opsForHash().delete(RedisKeyUtils.MAP_KEY_USER_LIKED, key);
//    }
//
//    @Override
//    public void incrementLikedCount(String likedUserId) {
//        redisTemplate.opsForHash().increment(RedisKeyUtils.MAP_KEY_USER_LIKED_COUNT, likedUserId, 1);
//    }
//
//    @Override
//    public void decrementLikedCount(String likedUserId) {
//        redisTemplate.opsForHash().increment(RedisKeyUtils.MAP_KEY_USER_LIKED_COUNT, likedUserId, -1);
//    }
//
//    @Override
//    public List<UserLike> getLikedDataFromRedis() {
//        Cursor<Map.Entry<Object, Object>> cursor = redisTemplate.opsForHash().scan(RedisKeyUtils.MAP_KEY_USER_LIKED, ScanOptions.NONE);
//        List<UserLike> list = new ArrayList<>();
//        while (cursor.hasNext()){
//            Map.Entry<Object, Object> entry = cursor.next();
//            String key = (String) entry.getKey();
//            //分离出 likedUserId，likedPostId
//            String[] split = key.split("::");
//            String likedUserId = split[0];
//            String likedPostId = split[1];
//            Integer value = (Integer) entry.getValue();
//
//            //组装成 UserLike 对象
//            UserLike userLike = new UserLike(likedUserId, likedPostId, value);
//            list.add(userLike);
//
//            //存到 list 后从 Redis 中删除
//            redisTemplate.opsForHash().delete(RedisKeyUtils.MAP_KEY_USER_LIKED, key);
//        }
//
//        return list;
//    }
//
//    @Override
//    public List<LikedCountDTO> getLikedCountFromRedis() {
//        Cursor<Map.Entry<Object, Object>> cursor = redisTemplate.opsForHash().scan(RedisKeyUtils.MAP_KEY_USER_LIKED_COUNT, ScanOptions.NONE);
//        List<LikedCountDTO> list = new ArrayList<>();
//        while (cursor.hasNext()){
//            Map.Entry<Object, Object> map = cursor.next();
//            //将点赞数量存储在 LikedCountDT
//            String key = (String)map.getKey();
//            LikedCountDTO dto = new LikedCountDTO(key, (Integer) map.getValue());
//            list.add(dto);
//            //从Redis中删除这条记录
//            redisTemplate.opsForHash().delete(RedisKeyUtils.MAP_KEY_USER_LIKED_COUNT, key);
//        }
//        return list;
//    }
//
//}
