package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.expection.BaseException;
import cn.wisenergy.common.utils.*;

import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.mapper.userLikesMapper;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.app.shopZx;
import cn.wisenergy.model.app.userLikes;
import cn.wisenergy.model.app.zxUserDto;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import cn.wisenergy.service.app.UploadService;
import java.io.File;
import java.util.*;
import javax.servlet.http.HttpServletRequest;
import cn.wisenergy.mapper.ShopZxMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


/**
 * Created by m1991 on 2021/2/24 13:42
 */
@Slf4j
@Transactional
@Service
public class UploadServiceImpl implements UploadService {

    @Autowired
    private ShopZxMapper shopZxMapper;

    @Autowired
    private UsersMapper usersMapper;

    @Autowired
    private userLikesMapper LikesMapper;

   // @Value("${file.upload.path:#{null}}")
    private String path;

    /**
     * 视频文件上传
     */
    @Override
    public Map<String, Object> uploadVideo(MultipartFile file,HttpServletRequest request,String zxField,String inviteCode) throws Exception {
        Map<String, Object> resultMap=new HashMap<String, Object>();
        /**
         * http://路径  request.getScheme() + "://" + request.getServerName()
         *                 + ":" + request.getServerPort()+/upload/";"
         */
        String basePath ="/upload/";
        Long time = System.currentTimeMillis();

        String fileName = file.getOriginalFilename();//文件原始名称
        String suffixName = fileName.substring(fileName.lastIndexOf("."));//从最后一个.开始截取。截取fileName的后缀名
        String newFileName = time+suffixName; //文件新名称
        //设置文件存储路径，可以存放在你想要指定的路径里面
        String rootPath="/opt/upload/video/"; //上传视频存放位置

        String filePath = rootPath+newFileName;
        File newFile = new File(filePath);
        //判断目标文件所在目录是否存在
        if(!newFile.getParentFile().exists()){
            //如果目标文件所在的目录不存在，则创建父目录
            newFile.getParentFile().mkdirs();
        }

        //将内存中的数据写入磁盘
        file.transferTo(newFile);
        //视频上传保存url
        String videoUrl = basePath + newFileName;

        //视频封面图处理
        String newImgName = time+".jpg";
        String framefile = rootPath + newImgName;
        String imgUrlSave = basePath+newImgName;//图片最终位置路径
        //视频截取封面图
        String imgUrl=FrameGrabberKit.getVedioImg(videoUrl, framefile, imgUrlSave);

        resultMap.put("videoUrl", videoUrl);
        resultMap.put("imgUrl", imgUrl);
        resultMap.put("code", 0);
        resultMap.put("msg","视频上传成功");
        String zxUrl=videoUrl;
        //System.out.println("上传的文件名为："+fileName+",后缀名为："+newFileName);
        /**
         * 生成当前时间戳
         */
        Long zxDate= System.currentTimeMillis();
        shopZxMapper.zxadd(zxUrl,zxField,inviteCode, zxDate);
        return resultMap;
    }

        /**
         * 图片文件上传
         */
        @Override
        public Map<String, Object> uploadImage(MultipartFile file,String inviteCode) throws Exception {
            Map<String, Object> resultMap=new HashMap<String, Object>();

            /**
             * 生成当前时间戳
             */
            Long zxDate= System.currentTimeMillis();

            String basePath = "/upload/";


            Long time = System.currentTimeMillis();

            String zxName = file.getOriginalFilename();//文件原始名称
            assert zxName != null;
            String suffixName = zxName.substring(zxName.lastIndexOf("."));//从最后一个.开始截取。截取zxName的后缀名
            String newzxName = time+suffixName; //文件新名称
            //设置文件存储路径，可以存放在你想要指定的路径里面
            String rootPath="/opt/upload/video/"; //上传图片存放位置
            String filePath = rootPath+newzxName;
            File newFile = new File(filePath);
            //判断目标文件所在目录是否存在
            if(!newFile.getParentFile().exists()){
                //如果目标文件所在的目录不存在，则创建父目录
                newFile.getParentFile().mkdirs();
            }

            User user=usersMapper.InvitedCode2(inviteCode);
            String userId=user.getUserId();
            //将内存中的数据写入磁盘
            file.transferTo(newFile);
            //图片上传保存url
            String zxUrl = basePath + newzxName;

            resultMap.put("zxUrl", zxUrl);
            resultMap.put("code", 0);
            resultMap.put("msg","头像上传成功！！！");
            shopZxMapper.zxadd1(zxUrl,userId);
            return resultMap;
        }

    /**
     * 多图片
     * @param files
     * @param zxField
     * @param inviteCode
     * @return
     */
    @Override
    public Map imageUpload(MultipartFile[] files, String zxField, String inviteCode) {
        //获取上传图片数量，打印在控制台
        System.out.println("上传图片数量" + files.length);
        String zxUrl = new String();
        //创建集合
        List<Map<String, Object>> root = new ArrayList<Map<String, Object>>();
        String fileName1=null;
        // 要上传的目标文件存放的绝对路径
//        final String localPath = path;
        Long time = new Date().getTime();
        String localPath = "/upload/";
        Map<String, Object> result = new HashMap<String, Object>();//一个文件上传的结果
        String msg = "";//上传结果信息
        //遍历图片数据
        for (MultipartFile file : files) {
            if (file.isEmpty()) {
                System.out.println("上传图片为空，请重新上传");
                Map map=new HashMap();
                map.put("code",0);
                map.put("msg","上传视频为空，请重新上传");
             return map;

            }
            //判断上传文件格式
            String fileType = file.getContentType();
            if (fileType.equals("image/jpeg") || fileType.equals("image/png")) {
                //上传后保存的文件名(需要防止图片重名导致的文件覆盖)
                //获取文件名
                fileName1 = file.getOriginalFilename();
                //获取文件后缀名
                String suffixName = fileName1.substring(fileName1.lastIndexOf("."));
                //重新生成文件名
                String fileName ="1"+UUID.randomUUID()+suffixName;//文件新名称
                //设置文件存储路径，可以存放在你想要指定的路径里面
                String Path="/opt/upload/video/"; //上传图片存放位置
                zxUrl+=localPath+fileName+",";
                if (FileUtils.upload(file,Path, fileName)) {
                    //文件存放的相对路径(一般存放在数据库用于img标签的src)
                    String relativePath ="用于判断是否图片上传成功，返回值有："+fileName;
                    result.put("relativePath", relativePath);//前端根据是否存在该字段来判断上传是否成功
                    msg = "图片上传成功";
                    result.put("zxUrl", zxUrl);
                } else {
                    msg = "图片上传失败";
                }
            } else {
                msg = "图片格式不正确";
            }
        }
//        result.put("msg", result_msg);
        //root.add(result);
       // String root_json = JSON.toJSONString(root);
       // System.out.println(root_json);
        result.put("code", 0);
        result.put("msg",msg);
        /**
         * 生成当前时间戳
         */
        Long zxDate= Long.valueOf(System.currentTimeMillis());
        shopZxMapper.zxadd(zxUrl,zxField,inviteCode, zxDate);
        return result;
    }

    /**
     * 多文件上传 TODO
     */
    private Path fileStorageLocation; // 文件在本地存储的地址

    public UploadServiceImpl() {
        if (!StringUtil.isBlank(path)) {
            this.fileStorageLocation = Paths.get(path).toAbsolutePath().normalize();
            try {
                Files.createDirectories(this.fileStorageLocation);
            } catch (IOException e) {
                throw new FileException("Could not create the directory", e);
            }
        }
    }

    /**
     * 存储文件到系统
     * @param file 文件
     * @return 文件名
     */
    @Override
    public String storeFile(MultipartFile file) {
        // Normalize file name
        String fileName = StringUtils.cleanPath(file.getOriginalFilename());

        try {
            // Check if the file's name contains invalid characters
            if(fileName.contains("..")) {
                throw new FileException("Sorry! Filename contains invalid path sequence " + fileName);
            }
            // Copy file to the target location (Replacing existing file with the same name)
            Path targetLocation = this.fileStorageLocation.resolve(fileName);
            Files.copy(file.getInputStream(), targetLocation, StandardCopyOption.REPLACE_EXISTING);
            return fileName;
        } catch (IOException ex) {
            throw new FileException("Could not store file " + fileName + ". Please try again!", ex);
        }
    }

    @Override
    public Resource loadFileAsResource(String fileName) {
        try {
            Path filePath = this.fileStorageLocation.resolve(fileName).normalize();
            Resource resource = new UrlResource(filePath.toUri());
            if(resource.exists()) {
                return resource;
            } else {
                throw new FileException("File not found " + fileName);
            }
        } catch (MalformedURLException  ex) {
            throw new FileException("File not found " + fileName, ex);
        }
    }

    /**
     *  资讯文件展示
     */
    @Override
    public Map selectPage(Integer pageNum, Integer pageSize,String inviteCode) {
        Map map = new HashMap();
        pageNum=pageNum-1;
        List<zxUserDto> shopZxList = shopZxMapper.selectPage(pageNum,pageSize);

        for (zxUserDto shopZx : shopZxList) {
            String[] zxUrl = shopZx.getZxUrl().split(",");
          ArrayList list =new ArrayList();
            if (null != zxUrl){
            for (String split:zxUrl) {

                boolean arrayList=Collections.addAll(list,split);

                    shopZx.setAskImgList(list);
                }
            }

            int likedId =shopZx.getZxid();
            if(shopZx.getUserId()==null&&""!=shopZx.getUserId()){
                map.put("code",1);
                map.put("msg","用户不存在！请重新开始！");
                return map;
            }
            shopZx.setUserId(shopZx.getUserId().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));

            if(null!=inviteCode&&""!=inviteCode) {
                //用户个人邀请码查询用户数据
                User user=usersMapper.InvitedCode2(inviteCode);
                String userLikeId=user.getUserId();
                userLikes d = LikesMapper.selectlikes(userLikeId, likedId);
                if (null == d) {
                    shopZx.setLikedStatus(0);
                } else {
                    shopZx.setLikedStatus(1);
                }

            }

        }

        map.put("data",shopZxList);

        return map;
    }

    /**
     * 资讯点赞实现
     * @param
     * @return
     */
    @Override
    public Map Ilike(Integer zxid, String inviteCode) {
        Map map = new HashMap();
        //用户个人邀请码查询用户数据
        User user=usersMapper.InvitedCode2(inviteCode);

        //用户等于null
        if(null == user || "".equals(user)){
            map.put("code",1);
            map.put("msg","用户信息不存在，请先注册！");
            return map;
            //用户存在
        }else {
            //判断该用户是否点过赞，如果点过赞，就返回信息告知前端，
            String userLikeId=user.getUserId();
            int likedId= zxid;
            userLikes b= LikesMapper.selectlikes(userLikeId, likedId);


            if(b==null){

                // 没有点过的话，就进行插入点赞记录表，更新点赞数
                Integer likedType=0;//点赞类型为扩展类型，暂时默认0
                Integer likedStaus=1; //更新点赞状态
                LikesMapper.addlikes(userLikeId,likedId,likedStaus,likedType);

                    shopZx shopZx = shopZxMapper.selectByzxid(zxid);
                    int a = shopZx.getZxLikes();
                    Integer zxLikes=shopZx.setZxLikes(a + 1);
                    shopZxMapper.updateByzxid(zxid,zxLikes);
                    map.put("LikedStatus",likedStaus);
                    map.put("code",0);
                    map.put("msg","点赞成功！");
                }else {

                    map.put("code",1);
                    map.put("msg","点赞失败！");
                };

        }

        return map;
    }

    /**
     * 资讯审核
     * @param zxid
     * @return
     */
    @Override
    public Map toExamine(Integer zxid) {
        Map map = new HashMap();
        try {
            shopZx shopZx = shopZxMapper.selectByzxid(zxid);
            if(null!=shopZx){
                Integer ZxToExamine=shopZx.setZxToExamine(1);
                shopZxMapper.updateZxToExaminezxid(zxid,ZxToExamine);
            }
            map.put("code",0);
            map.put("msg","审核通过！");
        }catch ( BaseException e){
            map.put("code",1);
            map.put("msg","审核失败！");
        };
        return map;
    }
}
