package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.CustomerService;
import cn.wisenergy.service.app.CustomerServiceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 专属客服
 */
@Api(tags = "专属客服")
@RestController
@RequestMapping("/customerService")
@Slf4j
public class CustomerServiceController {

    @Autowired
    private CustomerServiceService customerServiceService;

    /**
     * 给用户分配专属客服
     * @param userId
     * @return
     */
    @ApiOperation(value = "获取专属客服", notes = "获取专属客服")
    @GetMapping("/service")
    public R<String> getServiceByRand(String userId){
        try {
            CustomerService serviceByRand = customerServiceService.getServiceByRand(userId);
            String wechatImgUrl = serviceByRand.getWechatImgUrl();
            return R.ok(wechatImgUrl);
        }catch (Exception e){
            return R.error("获取失败，请重试");
        }
    }

    /**
     *  上传专属客服的二维码图片及微信ID
     * @param file  图片文件
     * @param request
     * @param wechatId   微信ID
     * @return
     */
    @ApiOperation(value = "设置专属客服二维码图片及微信id", notes = "设置专属客服二维码图片及微信id")
    @ResponseBody
    @PostMapping("/uploadWeChatImg")
    public R<String> uploadWeChatQRImg(@RequestParam("file")MultipartFile file,HttpServletRequest request,String wechatId){

        try {
            customerServiceService.uploadImage(file,request,wechatId);
        } catch (IOException e) {
            e.printStackTrace();
            R.error("上传失败");
        }
        return R.ok("上传成功");
    }

}
