package cn.wisenergy.mapper;

import cn.wisenergy.model.app.AccountInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Map;

/**
 * @author 86187
 */
public interface AccountMapper extends BaseMapper<AccountInfo> {

    /**
     * 添加
     *
     * @param accountInfo 账户信息
     * @return 1
     */
    int add(AccountInfo accountInfo);

    /**
     * 编辑
     *
     * @param accountInfo 账户信息
     * @return 1
     */
    int edit(AccountInfo accountInfo);

    /**
     * 删除
     *
     * @param id 主键id
     * @return 1
     */
    int delById(@Param("id") Integer id);

    /**
     * 通过userId获取账户信息
     *
     * @param userId 用户id
     * @return 账户信息
     */
    AccountInfo getByUserId(@Param("userId") String userId);

    /**
     * 通过userId 和 yearMonth获取账户信息
     *
     * @param userId    用户id
     * @param yearMonth 年月
     * @return 账户信息
     */
    AccountInfo getByUserIdAndTime(@Param("userId") String userId, @Param("yearMonth") String yearMonth);
}
