package cn.wisenergy.mapper;

import cn.wisenergy.model.app.OrderInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author 86187
 */
public interface OrderMapper extends BaseMapper<OrderInfo> {

    /**
     * 根据返佣状态获取 订单列表
     *
     * @param rebateStatus 0 未返佣  1 返佣
     * @return 订单列表
     */
    List<OrderInfo> getByRebateStatus(@Param("rebateStatus") Integer rebateStatus);

    /**
     * 有赞订单数据插入
     */
    void insertYouZanOrders(OrderInfo orderInfo);

    /**
     * 根据tid获取订单数据
     * @param tid 有赞生成的订单id
     * @return 一条订单数据
     */
    OrderInfo getByTid(@Param("tid")String tid);

}
