package cn.wisenergy.mapper;

import cn.wisenergy.model.app.TradeRecord;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author 86187
 */
public interface TradeRecordMapper extends BaseMapper<TradeRecord> {

    /**
     * 添加交易记录
     * @param tradeRecord 记录信息
     * @return 1
     */
    int add(TradeRecord tradeRecord);

    /**
     * 编辑交易记录
     * @param tradeRecord 记录信息
     * @return 1
     */
    int edit(TradeRecord tradeRecord);

    /**
     *  删除
     * @param id 主键
     * @return 1
     */
    int delById(@Param("id") Integer id);

    /**
     *  根据用户id,获取用户交易列表
     * @param userId 用户id
     * @return 用户交易列表
     */
    List<TradeRecord> getByUserId(@Param("userId") String  userId);

    /**
     *  根据用户id、年月 ,获取用户本月交易列表
     * @param userId 用户id
     * @return 用户交易列表
     */
    List<TradeRecord> getByUserIdAndTime(@Param("userId") String  userId,@Param("yearMonth") String yearMonth);
}
