package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zw
 * @ Description: 直推用户表
 * @ Author     : zw
 * @ Date       : 2021/2/25 12:57
 */

@Data
@ApiModel(value = "RecommendUser")
public class RecommendUser implements Serializable {
    private static final long serialVersionUID = 7885137366850583004L;

    /**
     * 直推用户主键id
     */
    @ApiModelProperty(name = "id", value = "直推用户主键id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(name = "userId", value = "用户id")
    private String userId;

    /**
     * 普通用户数量
     */
    @ApiModelProperty(name = "normal_user_num", value = "普通用户数量")
    private Integer  normalUserNum;

    /**
     * 幼苗数量
     */
    @ApiModelProperty(name = "seedling_num", value = "幼苗数量")
    private Integer  seedlingNum;

    /**
     * 青铜树数量
     */
    @ApiModelProperty(name = " bronze_tree_num", value = "青铜树数量")
    private Integer  bronzeTreeNum;

    /**
     * 白银树数量
     */
    @ApiModelProperty(name = "silver_tree_num", value = "白银树数量")
    private Integer  silverTreeNum;


    /**
     * 黄金树数量
     */
    @ApiModelProperty(name = "gold_tree_num", value = "黄金树数量")
    private Integer  goldTreeNum;

    /**
     * 农场主数量
     */
    @ApiModelProperty(name = "farmer_num", value = "农场主数量")
    private Integer  farmerNum;

    /**
     * 森林之星数量
     */
    @ApiModelProperty(name = "forest_start_num", value = "森林之星数量")
    private Integer  forestStartNum;

    /**
     * 西田森合伙人数量
     */
    @ApiModelProperty(name = "partner_num", value = "西田森合伙人数量")
    private Integer partnerNum;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;
}
