package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.AccumulatedIncomeVo;
import cn.wisenergy.model.vo.MoneyPackageDetailVo;
import cn.wisenergy.model.vo.MoneyPackageVo;
import cn.wisenergy.model.vo.WithdrawalAmountVo;

import java.util.List;

/**
 * @author 86187
 * @ Description: 钱包相关接口定义
 * @ Author     : 86187
 * @ Date       : 2021/3/2 14:33
 */
public interface WalletService {
    /**
     * 用户当月总收益
     *
     * @param userId 用户id
     * @return 当月总收益
     */
    R<MoneyPackageVo> getMoneyPackage(String userId);

    /**
     * 获取用户钱包-可提现
     *
     * @param userId 用户id
     * @return 钱包-可提现
     */
    R<WithdrawalAmountVo> getWithdrawalAmount(String userId);

    /**
     * 展示用户累计收益记录
     *
     * @param userId 用户id
     * @return 用户累计收益
     */
    R<List<AccumulatedIncomeVo>> showIncomeRecord(String userId);

    /**
     * 用户当月总收益
     *
     * @param userId 用户id
     * @return 当月总收益
     */
    R<MoneyPackageDetailVo> queryIncomeDetail(String userId);
}
