package cn.wisenergy.service.app.impl;

import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.User;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * @ Description: 用户接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:11
 * @author 86187
 */
@Service
@Slf4j
public class UserService extends ServiceImpl<UsersMapper, User> {

    @Autowired
    private UsersMapper userMapper;


    public String login(User user){//TODO：登陆逻辑函数
        try {
            User userExistN = userMapper.findByName(String.valueOf(user.getUserId()));
            if (userExistN != null){
                String userExistP = userMapper.findPswByName(String.valueOf(user.getUserId()));
                if (userExistP.equals(user.getPassword())){
                    return user.getUserId()+" 用户登录成功,欢迎您！";
                }else {
                    return "登陆失败,密码错误！";
                }
            }else {
                return "登陆失败，账户不存在";
            }
        }catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String regist(User user){//TODO：注册判断逻辑函数
        try{
            User userExist = userMapper.findByName(String.valueOf(user.getUserId()));
            if (user.getUserId().equals("")){
                return "账户名不能为空";
            }else if (user.getPassword().equals("")){
                return "密码不能为空";
            }else if (userExist != null){
                return "账户已经存在";
            }else {
                userMapper.save(user);
                return "注册成功";
            }
        }catch (Exception e){
            e.printStackTrace();
            return e.getMessage();
        }
    }
}
