package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.User;
import cn.wisenergy.service.app.UserService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 86187
 * @ Description: 用户接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:11
 */
@Service
@Slf4j
public class UserServiceImpl extends ServiceImpl<UsersMapper, User> implements UserService {

    @Autowired
    private UsersMapper usersMapper;

    @Override
    public R<User> getById(String userId) {

        return R.ok(usersMapper.getByUserId(userId));
    }

    @Override
    public User getByUserId(String userId) {
        return usersMapper.getByUserId(userId);
    }



    @Override
    public User queryUsersByPhone(String phone) {
        Map<String,Object> param=new HashMap<String, Object>();
        param.put("phone",phone);
        List<User> usersList=usersMapper.getUsersListByMap(param);
        if(!CollectionUtils.isEmpty(usersList)){
            return usersList.get(0);
        }
        return null;
    }

}
