package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.constant.RedisConsts;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.common.utils.RedisUtils;
import cn.wisenergy.common.utils.StringUtil;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.app.UsersDto;
import cn.wisenergy.service.app.UserService;
import cn.wisenergy.web.common.BaseController;
import cn.wisenergy.web.config.JwtConfig;
import cn.wisenergy.web.shiro.JwtUtil;
import cn.wisenergy.web.sms.*;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author 86187
 */
@Api(tags = "用户管理")
@RestController
@RequestMapping("/user")
@Slf4j
public class UserController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private JwtUtil jwtUtil;

    @Autowired
    private JwtConfig jwtConfig;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private RedisUtils redisUtils;

    @ApiOperation(value = "获取用户信息", notes = "获取用户信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/getByUserId")
    public R<User> getByUserId(String userId){
        return userService.getById(userId);
    }

    /**
     * shiro登录
     *
     * @return
     */
    @ApiOperation(value = "获取token接口", notes = "获取token接口", httpMethod = "POST")
    @PostMapping(value = "/login")
    public R<String> login(String id) {
        if (null == id) {
            return R.error("入参为空!");
        }

        //用户信息
        User user = userService.getByUserId(id);

        // 创建token
        String token = jwtUtil.generateToken(user);
        // 保存Redis
        redisTemplate.opsForValue().set(RedisConsts.JWT_ACCESS_TOKEN + token, token);
        return R.ok(token);
    }

//    /**
//     * 手机号登录
//     * @param userId
//     * @param sms
//     * @return
//     * @throws Exception
//     */
//    @ApiOperation(value = "获取用户手机号登录接口", notes = "获取用户手机号登录接口", httpMethod = "POST")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "userId", value = "用户手机号", required = true, dataType = "String"),
//            @ApiImplicitParam(name = "sms", value = "短信验证码", required = true, dataType = "String")})
//    @RequestMapping("/login/sms")
//    public Result loginBySms(String userId, String sms)throws Exception{
//        User users=null;
//        String key= StringUtil.formatKeyWithPrefix(Constants.RedisKey.PROJECT_PRIFIX,Constants.RedisKey.SMS_PRIFIX,userId,Constants.Sms.CodeType.LOGIN_OR_REGISTER+"");
//        String redisCode=redisUtils.getValue(key);
//        if(StringUtil.isBlank(redisCode) || !sms.equals(redisCode)){
//            throw new BaseException(ResultEnum.FAIL_VERIFY);
//        }
//        redisUtils.delete(key);
//        //根据手机号判断用户是否存在
//        //不存在则保存用户信息
//        users=userService.queryUsersByPhone(userId);
//        if(null==users){
//            users=new User();
////            users.setAccount(phone);
////            users.setUserName(phone);
////            userService.qdtxAddUsers(users);
//        }
//        String token=createToken(users);
//        if(!StringUtil.isBlank(token)){
//            return ResultUtils.returnDataSuccess(StringUtil.createSimpleMap("token",token));
//        }
//        return ResultUtils.returnFail();
//    }
//
//    public String createToken(User users)throws Exception{
//        String token=StringUtil.createToken();
//        //保存token
//        String tokenKey=StringUtil.formatKeyWithPrefix(Constants.RedisKey.PROJECT_PRIFIX,Constants.RedisKey.TOKEN_PRIFIX,token);
//        UsersDto usersDto=new UsersDto();
//        BeanUtils.copyProperties(users,usersDto);
//        redisUtils.set(tokenKey, JSONObject.toJSONString(usersDto),Constants.Duration.HALF_HOUR_INT);
//        return token;
//    }
}
