package cn.wisenergy.mapper;

import cn.wisenergy.model.app.User;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author 86187
 * @ Description:
 * @ Author     : 86187
 * @ Date       : 2021/1/6 15:32
 */
@Mapper
public interface UsersMapper extends BaseMapper<User> {
    /**
     * 添加
     *
     * @param user 用户信息
     * @return 用户信息
     */
    int add(User user);

    /**
     * 编辑
     *
     * @param user 用户信息
     * @return 修改是否成功
     */
    int edit(User user);

    /**
     * 删除
     *
     * @param id 用户id
     * @return 删除是否成功
     */
    int delById(@Param("id") Integer id);


    List<User> getList(Map<String, Object> map);

    List<User> findAll();
    User findByName(String name);
    String findPswByName(String UserName);
    void save(User user);

    /**
     *  获取用户信息
     * @param userId 用户id
     * @return 用户信息
     */
    User getByUserId(@Param("userId") String userId);

    /**
     *  获取用户信息
     * @param beInvitedCode 用户被邀请码
     * @return 用户信息
     */
    User getByBeInvitedCode(@Param("beInvitedCode") String beInvitedCode);

    /**
     * 获取黄金树以上会员用户
     * @return
     */
    List<User> getAllGoldUser();

}
