package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
*@ Description: 月度奖励实体类
*@ Author     : 86187
*@ Date       : 2021/2/24 16:16
 * @author 86187
 */
@Data
@ApiModel("MonthAward")
public class MonthAward implements Serializable {
    private static final long serialVersionUID = 5823242406761516398L;

    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id",name="id")
    private Integer id;

    /**
     * 本月月度肥料总额
     */
    @ApiModelProperty(value = "本月月度肥料总额",name="monthManureTotal")
    private BigDecimal monthManureTotal;

    /**
     * 本月进步最大奖励池
     */
    @ApiModelProperty(value = "本月进步最大奖励池",name="monthAwardPool")
    private BigDecimal monthAwardPool;

    /**
     * 月度肥料奖励
     */
    @ApiModelProperty(value = "月度肥料奖励",name="monthManureAward")
    private BigDecimal monthManureAward;


    /**
     * 黄金树月奖励总额
     */
    @ApiModelProperty(value = "黄金树月奖励总额",name="monthGoldAward")
    private BigDecimal monthGoldAward;


    /**
     * 农场主月奖励总额
     */
    @ApiModelProperty(value = "农场主月奖励总额",name="monthFarmerAward")
    private BigDecimal monthFarmerAward;

    /**
     * 森林之星月奖励总额
     */
    @ApiModelProperty(value = "森林之星月奖励总额",name="monthForestStartAward")
    private BigDecimal monthForestStartAward;

    /**
     * 森田合伙人月奖励总额
     */
    @ApiModelProperty(value = "森田合伙人月奖励总额",name="monthPartnerAward")
    private BigDecimal monthPartnerAward;


    private Date createTime;

    private Date updateTime;


}
