package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
*@ Description: 每月进步奖实体类
*@ Author     : 86187
*@ Date       : 2021/3/1 9:31
 * @author 86187
 */
@Data
public class ProgressPrize implements Serializable {
    private static final long serialVersionUID = -1533799058729746392L;

    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id",name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id",name = "userId")
    private String userId;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月",name = "yearMonth")
    private Date yearMonth;

    /**
     * 本月增长率
     */
    @ApiModelProperty(value = "本月增长率",name = "growthRate")
    private BigDecimal  growthRate;

    /**
     * 进步奖奖金
     */
    @ApiModelProperty(value = "进步奖奖金",name = "awardMoney")
    private BigDecimal awardMoney;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间",name = "createTime")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间",name = "updateTime")
    private Date updateTime;

}
