package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 86187
 * @ Description: 团队业绩实体类
 * @ Author     : 86187
 * @ Date       : 2021/2/26 16:31
 */
@Data
@ApiModel("TeamPerformance")
public class TeamPerformance implements Serializable {
    private static final long serialVersionUID = 3124781800304763059L;

    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id", name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private String userId;

    /**
     * 用户等级
     */
    @ApiModelProperty(value = "用户等级", name = "userLevel")
    private Integer userLevel;

    /**
     * 年-月
     */
    @ApiModelProperty(value = "年-月", name = "yearMonth")
    private Date yearMonth;

    /**
     * 本月团队业绩
     */
    @ApiModelProperty(value = "本月团队业绩", name = "monthTeamPerformance")
    private BigDecimal monthTeamPerformance;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", name = "createTime")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", name = "updateTime")
    private Date updateTime;

}
