package cn.wisenergy.model.enums;

/**
 * @author 86187
 * @ Description:  用户会员等级枚举类
 * @ Author     : 86187
 * @ Date       : 2021/3/1 11:14
 */
public enum UserLevelEnum {

    /**
     * 会员等级
     */
    NORMAL_USER(0, "普通用户"),

    SEEDLING(1, "幼苗"),

    BRONZE_TREE(2, "青铜树"),

    SILVER_TREE(3, "白银树"),

    GOLD_TREE(4, "黄金树"),

    FARMER(6, "农场主"),

    FOREST_START(7, "森林之星"),

    PARTNER(8, "西田森合伙人");
    private Integer code;

    private String desc;

    UserLevelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
