package cn.wisenergy.service.Manager;

import cn.wisenergy.mapper.AccountMapper;
import cn.wisenergy.mapper.OrderMapper;
import cn.wisenergy.mapper.TeamPerformanceMapper;
import cn.wisenergy.mapper.TradeRecordMapper;
import cn.wisenergy.model.app.*;
import cn.wisenergy.model.enums.RebateStatusEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author 86187
 * @ Description: 账户管理公共类
 * @ Author     : 86187
 * @ Date       : 2021/2/23 10:43
 */
@Component
@Slf4j
public class AccountManager {

    @Autowired
    private OrderMapper orderMapper;

    @Autowired
    private AccountMapper accountMapper;

    @Autowired
    private TradeRecordMapper recordMapper;

    @Autowired
    private TeamPerformanceMapper teamPerformanceMapper;

    /**
     * 保存用户佣金
     *
     * @param orderInfo     订单信息
     * @param accountInfo   账户信息
     * @param memberPercent 会员等级百比分
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateOrderAddMoney(OrderInfo orderInfo, AccountInfo accountInfo, MemberPercent memberPercent) {
        //1、计算返佣金额
        BigDecimal bigDecimal = orderInfo.getPayment().multiply(memberPercent.getPercent());
        BigDecimal extractMoney = accountInfo.getExtractMoney().add(bigDecimal);
        accountInfo.setExtractMoney(extractMoney);

        BigDecimal performanceMonth = accountInfo.getEarningsMonth().add(bigDecimal);
        accountInfo.setEarningsMonth(performanceMonth);

        BigDecimal performanceTotal = accountInfo.getEarningsMonth().add(bigDecimal);
        accountInfo.setEarningsMonth(performanceTotal);
        //2、修改订单返佣状态：已返佣 1
        orderInfo.setRebateStatus(RebateStatusEnum.ALREADY_REBATE.getCode());

        orderMapper.updateById(orderInfo);

        //3、增加账户可用金额
        accountMapper.updateById(accountInfo);

        //4、添加交易流水记录
        TradeRecord tradeRecord = new TradeRecord();
        tradeRecord.setUserId(orderInfo.getBuyerId());
        tradeRecord.setTradeType(2);
        tradeRecord.setTradeNo(orderInfo.getTid());
        recordMapper.add(tradeRecord);
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateAccountPerformanceMonth(List<TeamPerformance> list) {
        for (TeamPerformance teamPerformance : list) {
            teamPerformanceMapper.updateById(teamPerformance);
        }
    }
}
