package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.FileUtils;
import cn.wisenergy.model.app.shopZx;
import cn.wisenergy.service.app.UploadService;


import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;

import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;

import org.springframework.web.bind.annotation.RequestMapping;

import java.util.*;
import java.util.stream.Collectors;


/**
 * Created by m1991 on 2021/2/24 13:46
 */
@Api(tags = "资讯管理")
@RestController
@RequestMapping("/ZX")
@Slf4j
public class UploadController {

    @Autowired
    private UploadService uploadService;

    /**
     * @param request
     * @return
     * @throws Exception
     */
    /**
     * 视频文件上传
     * 资讯主键id* 视频/封面存放地址* 用户id(作者id)
     * 获赞数* 视频/图片名称* 审核字段* 资讯文字输入字段
     * 资讯创建时间* 图片储存地址* 资讯发表地址
     *
     * @param file
     * @param request
     * @param userId
     * @param zxField
     * @param zxAddress
     * @return
     * @throws Exception
     */
    @ApiOperation(value = "上传视频,返回路径给前台", notes = "上传视频,返回路径给前台", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "zxField", value = "资讯文字", required = false, dataType = "String"),
            @ApiImplicitParam(name = "userId", value = "用户手机号", required = true, dataType = "String")})
    @RequestMapping(value = "/uploadVideo", method = RequestMethod.POST)
    public Map<String, Object> uploadVideo(MultipartFile file, HttpServletRequest request, String userId, String zxField, String zxAddress) throws Exception {
        return uploadService.uploadVideo(file, request, userId, zxField, zxAddress);
    }

    /**
     * 单图片文件上传
     *
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value = "上传图片,返回路径给前台", notes = "上传图片,返回路径给前台", httpMethod = "POST", produces = "application/json; charset=UTF-8")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "zxField", value = "资讯文字", required = false, dataType = "String"),
            @ApiImplicitParam(name = "userId", value = "用户手机号", required = true, dataType = "String")})
    @RequestMapping(value = "/uploadImage", method = RequestMethod.POST)
    public Map<String, Object> uploadImage(MultipartFile file, HttpServletRequest request, String userId, String zxField, String zxAddress) throws Exception {


        return uploadService.uploadImage(file, request, userId, zxField, zxAddress);
    }


    /**
     * 多文件上传
     *
     * @param files    @RequestParam("file")    /**
     * *  多文件上传接口
     * *  T0D0 value = "/fileUpload", produces = "application/json;charset=UTF-8
     * *
     * @return
     */
    private static final Logger logger = LoggerFactory.getLogger(UploadController.class);

    @ApiOperation(value = "上传多图片,返回路径给前台", notes = "上传图片,返回路径给前台", httpMethod = "POST", produces = "application/json; charset=UTF-8")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "zxField", value = "资讯文字", required = false, dataType = "String"),
            @ApiImplicitParam(name = "zxAddress", value = "发表地址", required = false, dataType = "String"),
            @ApiImplicitParam(name = "userId", value = "用户手机号", required = true, dataType = "String")})
    @RequestMapping("/multipleImageUpload")
    public List multipleImageUpload(MultipartFile[] files,String userId, String zxField, String zxAddress) {
        return uploadService.imageUpload(files, userId, zxField, zxAddress);

        //    ,
    }


}