package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.constant.RedisConsts;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.User;
import cn.wisenergy.service.app.UserService;
import cn.wisenergy.web.common.BaseController;
import cn.wisenergy.web.config.JwtConfig;
import cn.wisenergy.web.shiro.JwtUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 86187
 */
@Api(tags = "用户管理")
@RestController
@RequestMapping("/user")
@Slf4j
public class UserController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private JwtUtil jwtUtil;

    @Autowired
    private JwtConfig jwtConfig;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @ApiOperation(value = "获取用户信息", notes = "获取用户信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/getByUserId")
    public R<User> getByUserId(String userId){
        return userService.getById(userId);
    }

    /**
     * shiro登录
     *
     * @return
     */
    @ApiOperation(value = "获取token接口", notes = "获取token接口", httpMethod = "POST")
    @PostMapping(value = "/login")
    public R<String> login(String id) {
        if (null == id) {
            return R.error("入参为空!");
        }

        //用户信息
        User user = userService.getByUserId(id);

        // 创建token
        String token = jwtUtil.generateToken(user);
        // 保存Redis
        redisTemplate.opsForValue().set(RedisConsts.JWT_ACCESS_TOKEN + token, token);
        return R.ok(token);
    }
}
