package cn.wisenergy.common.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;

import java.io.*;
import java.util.Properties;

@Slf4j
public class FileUtil {

    /**
     * @param filePath
     * @return
     * @throws IOException
     * @Title: readProperties
     * @Description: 读取prop配置文件获取Properties对象
     */
    public static Properties readProperties(String filePath) throws IOException {
        // 创建Properties文件
        Properties prop = new Properties();
        // 获取流
        InputStream input = FileUtil.class.getClassLoader().getResourceAsStream(filePath);
        // 导入流
        prop.load(input);
        return prop;
    }

    /**
     * @param filePath 文件的路径
     * @return
     * @Title: readJsonFile
     * @Description: 将JSON文件读取为JSON字符串
     */
    public static String readJsonFile(String filePath) {
        String laststr = "";
        File file = new File(filePath);// 打开文件
        BufferedReader reader = null;
        try {
            FileInputStream in = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));// 读取文件
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr = laststr + tempString;
            }
            reader.close();
        } catch (IOException e) {
        	log.error(e.getMessage(),e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException el) {
                	log.error(el.getMessage(),el);
                }
            }
        }
        return laststr;
    }

    /**
     * 将URL远程路径文件转成InputStream返回
     *
     * @param url
     *            远程地址
     * @return InputStream
     */
    public static InputStream remotePathToStream(String url) {
        InputStream inputStream = null;
        try {
            CloseableHttpClient httpsClient = HttpUtil.createSSLClientDefault();
            HttpGet get = new HttpGet(url);
            HttpResponse response = httpsClient.execute(get);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                inputStream = response.getEntity().getContent();
            }
        } catch (Exception e) {
            ExceptionUtils.getStackTrace(e);
        }
        return inputStream;
    }

}
