package cn.wisenergy.mapper;

import cn.wisenergy.model.app.BankInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author 86187
 */
public interface BankInfoMapper extends BaseMapper<BankInfo> {

    /**
     * 添加银行卡信息
     *
     * @param bankInfo 银行卡信息
     * @return 1
     */
    int add(BankInfo bankInfo);

    /**
     * 编辑银行卡信息
     *
     * @param bankInfo 银行卡信息
     * @return 1
     */
    int edit(BankInfo bankInfo);

    /**
     * 删除银行卡信息
     *
     * @param id 银行卡id
     * @return 1
     */
    int delById(@Param("id") Integer id);

    /**
     * 通过用户id,获取用户银行卡信息
     *
     * @param userId 用户id
     * @return 1
     */
    BankInfo getByUserId(@Param("userId") String userId);
}
