package cn.wisenergy.mapper;

import cn.wisenergy.model.app.MemberPercent;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author 86187
 */
public interface MemberPercentMapper extends BaseMapper<MemberPercent> {
    /**
     * 保存
     * @param memberPercent 入参
     * @return 1
     */
    int add(MemberPercent memberPercent);

    /**
     * 编辑
     *
     * @param memberPercent 入参
     * @return 1
     */
    int edit(MemberPercent memberPercent);

    /**
     * 删除
     *
     * @param id 主键id
     * @return 1
     */
    int delById(@Param("id") Integer id);

    /**
     *  获取等级 某个类型的比列
     * @param userLevel 会员等级
     * @param type 类型
     * @return 返佣比例
     */
    MemberPercent getByLevelAndType(@Param("userLevel") Integer userLevel, @Param("type") Integer type);

}
