package cn.wisenergy.mapper;

import cn.wisenergy.model.app.User;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author 86187
 * @ Description:
 * @ Author     : 86187
 * @ Date       : 2021/1/6 15:32
 */
@Mapper
public interface UsersMapper extends BaseMapper<User> {
    /**
     * 添加
     *
     * @param user 用户信息
     * @return 用户信息
     */
    int add(User user);

    /**
     * 编辑
     *
     * @param user 用户信息
     * @return 修改是否成功
     */
    int edit(User user);

    /**
     * 删除
     *
     * @param id 用户id
     * @return 删除是否成功
     */
    int delById(@Param("id") Integer id);


    List<User> getList(Map<String, Object> map);

    List<User> findAll();
    User findByName(String name);
    String findPswByName(String UserName);
    void save(User user);

    /**
     *  获取用户信息
     * @param userId 用户id
     * @return 用户信息
     */
    User getByUserId(@Param("userId") String userId);

    /**
     *  获取用户信息
     * @param userId 用户id
     * @return 用户信息
     */
    Integer ByUserId(@Param("userId") String userId);

    /**
     *  获取用户信息
     * @param
     * @return 用户信息
     */
    Integer beInvitedCode1(@Param("beInvitedCode") String beInvitedCode);

    /**
     *  获取用户信息
     * @param beInvitedCode 用户被邀请码
     * @return 用户信息
     */
    User getByBeInvitedCode(@Param("beInvitedCode") String beInvitedCode);

    /**
     * 获取黄金树以上会员用户
     * @return
     */
    List<User> getAllGoldUser();

    /**
     * 查询用户
     * @param param
     * @return
     */
    public List<User>	getUsersListByMap(Map<String,Object> param);

    //根据手机号查询用户Integer
    User queryUsersByPhone(@Param("userId")String userId);

    //根据用户的推荐人邀请码比对推荐人的本人邀请码，查询推荐人的用户ID
    Integer inviteCodeBeInvitedCode(@Param("beInvitedCode")Integer beInvitedCode);

    /**
     * 用户注册
     * @param userId
     * @param inviteCode
     * @param beInvitedCode
     * @param userLevel
     */
    Integer save(@Param("userId")String userId, @Param("inviteCode") String inviteCode, @Param("beInvitedCode") String beInvitedCode, @Param("userLevel") Integer userLevel);
    Integer insertbyint(@Param("userId")String userId,  @Param("beInvitedCode") String beInvitedCode);

    User edit1(int userLevel, String intiveCode,String userId);

    Integer edit2(User user);
    Integer getuserIdById(@Param("userId")String userId);
    Integer BYQMById(@Param("userId")String userId);
    /**
     * 根据userid获取获取所有的直接推荐人
     * @param inviteCode 用户本人的邀请码
     * @return 所有填写此人的邀请码的用户
     */
    List<User> getByInviteCode(@Param("inviteCode") String inviteCode, @Param("userLevel") int userLevel);

    /**
     * 通过邀请码，获取用户信息
     * @param inviteCode 邀请码
     * @return 用户信息
     */
    User queryByInviteCode(@Param("inviteCode") String inviteCode);
}
