package cn.wisenergy.model.app;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zhangwei
 * @ Description: 有赞订单表
 * @ Author     : zhangwei
 * @ Date       : 2021/2/22 16:00
 */
@Data
@ApiModel(value = "OrderInfo")
@TableName("order_info")
public class OrderInfo {

    /**
     * 账户主键id
     */
    @ApiModelProperty(name = "id", value = "订单主键id")
    private Long id;

    /**
     * 买家id
     */
    @ApiModelProperty(name = "buyerId", value = "买家id")
    private String buyerId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private String itemId;

    /**
     * 订单支付类型
     */
    @ApiModelProperty(name = "payType", value = "订单支付类型")
    private String payType;

    /**
     * 订单更新时间
     */
    @ApiModelProperty(name = "youzanUpdateTime", value = "订单更新时间")
    private Date youzanUpdateTime;


    /**
     * 有赞订单号
     */
    @ApiModelProperty(name = "tid", value = "有赞订单号")
    private String tid;

    /**
     * 订单创建时间
     */
    @ApiModelProperty(name = "created", value = "订单创建时间")
    private Date created;

    /**
     * 店铺类型
     */
    @ApiModelProperty(name = "teamType", value = "店铺类型")
    private Long teamType;

    /**
     * 订单支付时间
     */
    @ApiModelProperty(name = "payTime", value = "订单支付时间")
    private Date payTime;

    /**
     * 支付渠道
     */
    @ApiModelProperty(name = "payTypeStr", value = "支付渠道")
    private String payTypeStr;

    /**
     * 订单关闭类型
     */
    @ApiModelProperty(name = "closeType", value = "订单关闭类型")
    private Integer closeType;

    /**
     * 退款状态
     */
    @ApiModelProperty(name = "refundState  ", value = "退款状态")
    private Long refundState;

    /**
     * 交易完成时间
     */
    @ApiModelProperty(name = "successTime", value = "交易完成时间")
    private Date successTime;

    /**
     * 实际支付价格
     */
    @ApiModelProperty(name = "payment", value = "实际支付价格")
    private BigDecimal payment;

    /**
     * 返佣状态 0:未返佣  1：返佣
     */
    @ApiModelProperty(name = "rebateStatus", value = "返佣状态")
    private Integer rebateStatus;

    /**
     * 当月订单处理状态  0: 未处理  1：处理
     */
    @ApiModelProperty(name = "monthOrderStatus", value = "当月订单处理状态")
    private Integer monthOrderStatus;

    /**
     * 月度任务处理状态  0:未处理 1：处理
     */
    @ApiModelProperty(name = "rebateStatus", value = "月度任务处理状态")
    private Integer monthlyTaskStatus;

    /**
     * updateTime
     */
    @ApiModelProperty(name = "updateTime", value = "update_time")
    private Date updateTime;

    /**
     * createTime
     */
    @ApiModelProperty(name = "createTime", value = "createTime")
    private Date createTime;
}
