package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 86187
 * @ Description: 交易记录流水表
 * @ Author     : 86187
 * @ Date       : 2021/2/22 14:49
 */
@Data
@ApiModel("TradeRecord")
public class TradeRecord implements Serializable {
    private static final long serialVersionUID = -8502447089897962007L;

    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(name = "userId", value = "用户id")
    private String userId;

    /**
     * 交易记录类型 1：提现 2：订单返佣 3：订单下单 4：月度肥料 5：培育奖 6：工资奖励
     */
    @ApiModelProperty(name = "tradeType", value = "交易类型 1：提现 2：订单返佣 3：订单下单 4：月度肥料 5：培育奖 6：工资")
    private Integer tradeType;

    /**
     * 交易关联订单号
     */
    @ApiModelProperty(name = "tradeNo", value = "交易关联订单号")
    private String tradeNo;

    /**
     * 交易状态：0：未结算 1：已结算 2：银行转账中 3：提现成功
     */
    @ApiModelProperty(name = "status", value = "交易状态：0：未结算 1：已结算 2：银行转账中 3：提现成功")
    private Integer status;

    /**
     * 定时任务id
     */
    @ApiModelProperty(name = "taskId", value = "定时任务id")
    private Integer taskId;

    /**
     * 金额
     */
    @ApiModelProperty(name = "money", value = "金额")
    private BigDecimal money;

    /**
     * 银行卡卡号
     */
    @ApiModelProperty(name = "cardNumber", value = "银行卡卡号")
    private String cardNumber;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

}
