package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author 86187
 * @ Description: 钱包收益详情展示Vo
 * @ Author     : 86187
 * @ Date       : 2021/3/2 17:25
 */
@Data
@ApiModel("MoneyPackageDetailVo")
public class MoneyPackageDetailVo {
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private String userId;

    /**
     * 收益明细
     */
    @ApiModelProperty(value = "收益明细", name = "list")
    List<IncomeDetailVo> list;

    /**
     * 累计收益
     */
    @ApiModelProperty(value = "累计收益", name = "totalIncome")
    private BigDecimal totalIncome;


}
