package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.vo.AerialDeliveryVo;

import java.util.Map;

/**
 * @author 86187
 * @ Description: 用户接口
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:08
 * @author 86187
 */
public interface UserService {


    /**
     * 获取用户信息
     * @param userId 用户id
     * @return 用户信息
     */
     User getById(String userId);

     R<Integer> getById1(String userId);

    /**
     * 获取用户信息
     * @param userId 用户id
     * @return 用户信息
     */
    User getByUserId(String userId);

    /**
     * 根据手机号查询用户
     */
    User queryUsersByPhone(String userId);

    /**
     * 根据OpenId查询用户
     */
    User queryUsersByOpenId(String openId);

    /**
     * 用户注册
     */
    Map userByZx(String userId, String beInvitedCode);


    Integer getUserIdById(String userId);

    /**
     * 空投池
     *
     * @return 用户列表信息
     */
    R<AerialDeliveryVo> queryAerialDelivery();

    R<Boolean> setHeadImage(String userId, String headImage);

    R<Boolean> fillInInviteCode(String userId, String inviteCode);
}
